/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gems.gem;

import de.saumya.mojo.gems.gem.Gem;
import de.saumya.mojo.gems.gem.GemFileEntry;
import de.saumya.mojo.gems.gem.GemPackager;
import de.saumya.mojo.gems.spec.GemSpecification;
import de.saumya.mojo.gems.spec.GemSpecificationIO;
import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.gzip.GZipArchiver;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogger;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;

@Component(role=GemPackager.class)
public class DefaultGemPackager
implements GemPackager {
    @Requirement(hints={"yaml"})
    private GemSpecificationIO gemSpecificationIO;

    public File createGemStub(GemSpecification gemspec, File target) throws IOException {
        return this.createGem(new Gem(gemspec), target);
    }

    public File createGem(Gem gem, File target) throws IOException {
        File gemWorkdir = new File(File.createTempFile("nexus-gem-work", ".tmp").getParentFile(), "wd-" + System.currentTimeMillis());
        gemWorkdir.mkdirs();
        if (!gem.getGemFiles().isEmpty()) {
            for (GemFileEntry entry : gem.getGemFiles()) {
                if (entry.getSource().isFile()) continue;
                throw new IOException("The GEM entry must be a file!");
            }
        }
        String gemspecString = this.gemSpecificationIO.write(gem.getSpecification());
        try {
            File metadata = new File(gemWorkdir, "metadata");
            File metadataGz = new File(gemWorkdir, "metadata.gz");
            FileUtils.fileWrite((String)metadata.getAbsolutePath(), (String)"UTF-8", (String)gemspecString);
            GZipArchiver gzip = new GZipArchiver();
            gzip.setDestFile(metadataGz);
            gzip.addFile(metadata, "metadata.gz");
            gzip.createArchive();
            TarArchiver tar = new TarArchiver();
            tar.enableLogging((Logger)new AbstractLogger(0, "nologging"){

                public void warn(String message, Throwable throwable) {
                }

                public void info(String message, Throwable throwable) {
                }

                public Logger getChildLogger(String name) {
                    return null;
                }

                public void fatalError(String message, Throwable throwable) {
                }

                public void error(String message, Throwable throwable) {
                }

                public void debug(String message, Throwable throwable) {
                }
            });
            TarArchiver.TarCompressionMethod compression = new TarArchiver.TarCompressionMethod();
            File dataTarGz = null;
            if (!gem.getGemFiles().isEmpty()) {
                dataTarGz = new File(gemWorkdir, "data.tar.gz");
                compression.setValue("gzip");
                tar.setCompression(compression);
                tar.setDestFile(dataTarGz);
                for (GemFileEntry entry : gem.getGemFiles()) {
                    if (entry.getSource().isFile()) {
                        tar.addFile(entry.getSource(), entry.getPathInGem());
                        continue;
                    }
                    if (!entry.getSource().isDirectory()) continue;
                    tar.addDirectory(entry.getSource(), entry.getPathInGem());
                }
                tar.createArchive();
            }
            File gemFile = new File(target, gem.getGemFilename());
            tar.setDestFile(gemFile);
            compression.setValue("none");
            tar.setCompression(compression);
            if (dataTarGz != null) {
                tar.addFile(dataTarGz, dataTarGz.getName());
            }
            tar.addFile(metadataGz, metadataGz.getName());
            tar.createArchive();
            File file = gemFile;
            return file;
        }
        catch (ArchiverException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            FileUtils.forceDelete((File)gemWorkdir);
        }
    }
}

