/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby.rails;

import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.gems.GemManager;
import de.saumya.mojo.ruby.gems.GemsInstaller;
import de.saumya.mojo.ruby.rails.RailsException;
import de.saumya.mojo.ruby.rails.RailsManager;
import de.saumya.mojo.ruby.rails.RailsState;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.IOException;

public class RailsService {
    private final GemsInstaller installer;
    private final RailsManager manager;
    private final RailsState state;
    private final Object session;

    public RailsService(RailsState state, Object repositorySystemSession, ScriptFactory factory, GemManager gemManager, RailsManager manager) throws RailsException, IOException {
        assert (state != null);
        assert (this.session != null);
        assert (factory != null);
        assert (manager != null);
        this.state = state;
        this.session = repositorySystemSession;
        this.installer = new GemsInstaller(state.getRubygemsConfig(), factory, gemManager);
        this.manager = manager;
        manager.initInstaller(this.installer, state.getLaunchDirectory());
    }

    public void resetState() throws RailsException, IOException {
        this.manager.initInstaller(this.installer, this.state.getLaunchDirectory());
    }

    public void createNew(String appPath, String railsVersion, String ... args) throws RailsException, GemException, IOException, ScriptException {
        this.manager.createNew(this.installer, this.session, new File(appPath), null, railsVersion, null, args);
    }

    public void rake(String tasks) throws IOException, ScriptException, GemException, RailsException {
        this.manager.rake(this.installer, this.session, this.state.getLaunchDirectory(), this.state.getRubygemsConfig().getEnvironment(), tasks, new String[0]);
    }

    public void generate(String generator, String ... args) throws IOException, ScriptException, GemException, RailsException {
        this.manager.generate(this.installer, this.session, this.state.getLaunchDirectory(), generator, args);
    }
}

