/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby.script;

import de.saumya.mojo.ruby.script.Arguments;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class Script
extends Arguments {
    private final ScriptFactory scriptFactory;
    private final String script;

    Script(ScriptFactory scriptFactory) {
        this.scriptFactory = scriptFactory;
        this.script = null;
    }

    Script(ScriptFactory scriptFactory, String script) {
        this.scriptFactory = scriptFactory;
        this.script = script;
    }

    Script(ScriptFactory scriptFactory, URL url) {
        this(scriptFactory, url.toString(), false);
    }

    Script(ScriptFactory scriptFactory, File file) {
        this(scriptFactory, file.getAbsolutePath(), false);
    }

    Script(ScriptFactory scriptFactory, String file, boolean search) {
        this.scriptFactory = scriptFactory;
        if (search) {
            this.add("-S");
            this.add(file);
            this.script = null;
        } else {
            this.script = "load('" + file + "')";
        }
    }

    public boolean isValid() {
        return this.list.size() > 0 || this.script != null;
    }

    public Script addArg(File name) {
        super.add(name.getAbsolutePath());
        return this;
    }

    public Script addArg(String name) {
        super.add(name);
        return this;
    }

    public Script addArg(String name, String value) {
        if (value != null) {
            super.add(name, value);
        }
        return this;
    }

    public Script addArg(String name, File value) {
        if (value != null) {
            super.add(name, value.getAbsolutePath());
        }
        return this;
    }

    public Script addArgs(String line) {
        super.parseAndAdd(line);
        return this;
    }

    public void execute() throws ScriptException, IOException {
        if (this.script != null) {
            this.scriptFactory.launcher.executeScript(this.script, this.list);
        } else {
            this.scriptFactory.launcher.execute(this.list);
        }
    }

    public void execute(File output) throws ScriptException, IOException {
        if (this.script != null) {
            this.scriptFactory.launcher.executeScript(this.script, this.list, output);
        } else {
            this.scriptFactory.launcher.execute(this.list, output);
        }
    }

    public void executeIn(File launchDirectory) throws ScriptException, IOException {
        if (this.script != null) {
            this.scriptFactory.launcher.executeScript(launchDirectory, this.script, this.list);
        } else {
            this.scriptFactory.launcher.executeIn(launchDirectory, this.list);
        }
    }

    public void executeIn(File launchDirectory, File output) throws ScriptException, IOException {
        if (this.script != null) {
            this.scriptFactory.launcher.executeScript(launchDirectory, this.script, this.list, output);
        } else {
            this.scriptFactory.launcher.executeIn(launchDirectory, this.list, output);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.script != null) {
            buf.append(this.script).append(" ");
        }
        for (String arg : this.list) {
            buf.append(arg).append(" ");
        }
        return buf.toString().trim();
    }
}

