/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriverEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.OutputBusyException;
import de.schlichtherle.truezip.io.SequentialIOException;
import de.schlichtherle.truezip.io.SequentialIOExceptionBuilder;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.JSE7;
import de.schlichtherle.truezip.util.JointIterator;
import de.schlichtherle.truezip.zip.RawZipOutputStream;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ZipOutputShop
extends RawZipOutputStream<ZipDriverEntry>
implements OutputShop<ZipDriverEntry> {
    private final ZipDriver driver;
    private final FsModel model;
    @CheckForNull
    private IOPool.Entry<?> postamble;
    @CheckForNull
    private ZipDriverEntry bufferedEntry;
    private ZipCryptoParameters param;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ZipOutputShop(ZipDriver driver, FsModel model, @WillCloseWhenClosed OutputStream out, @CheckForNull @WillNotClose ZipInputShop source) throws IOException {
        super(out, null != source && source.isAppendee() ? source : null, driver);
        if (null == model) {
            throw new NullPointerException();
        }
        this.driver = driver;
        this.model = model;
        if (null != source) {
            if (!source.isAppendee()) {
                super.setComment(source.getComment());
                if (0L < source.getPreambleLength()) {
                    InputStream in = source.getPreambleInputStream();
                    try {
                        Streams.cat((InputStream)in, (OutputStream)(source.offsetsConsiderPreamble() ? this : out));
                    }
                    finally {
                        in.close();
                    }
                }
            }
            if (0L < source.getPostambleLength()) {
                this.postamble = (IOPool.Entry)this.getIOPool().allocate();
                Streams.copy((InputStream)source.getPostambleInputStream(), (OutputStream)this.postamble.getOutputSocket().newOutputStream());
            }
        }
    }

    public FsModel getModel() {
        return this.model;
    }

    private IOPool<?> getIOPool() {
        return this.driver.getPool();
    }

    @Override
    protected ZipCryptoParameters getCryptoParameters() {
        ZipCryptoParameters param = this.param;
        if (null == param) {
            this.param = param = this.driver.zipCryptoParameters(this);
        }
        return param;
    }

    public int getSize() {
        return super.size() + (null != this.bufferedEntry ? 1 : 0);
    }

    @Override
    public Iterator<ZipDriverEntry> iterator() {
        ZipDriverEntry tempEntry = this.bufferedEntry;
        if (null == tempEntry) {
            return super.iterator();
        }
        return new JointIterator(super.iterator(), Collections.singletonList(tempEntry).iterator());
    }

    @Override
    @CheckForNull
    public ZipDriverEntry getEntry(String name) {
        ZipDriverEntry entry = (ZipDriverEntry)super.getEntry(name);
        if (null != entry) {
            return entry;
        }
        entry = this.bufferedEntry;
        return null != entry && name.equals(entry.getName()) ? entry : null;
    }

    public OutputSocket<ZipDriverEntry> getOutputSocket(final ZipDriverEntry local) {
        if (null == local) {
            throw new NullPointerException();
        }
        final class Output
        extends OutputSocket<ZipDriverEntry> {
            Output() {
            }

            public ZipDriverEntry getLocalTarget() {
                return local;
            }

            public OutputStream newOutputStream() throws IOException {
                if (ZipOutputShop.this.isBusy()) {
                    throw new OutputBusyException(local.getName());
                }
                if (local.isDirectory()) {
                    ZipOutputShop.this.updateProperties(local, DirectoryTemplate.INSTANCE);
                    return new EntryOutputStream(local, false);
                }
                boolean process = ZipOutputShop.this.updateProperties(local, this.getPeerTarget());
                if (0 == local.getMethod() && (-1L == local.getCrc() || -1L == local.getSize() || -1L == local.getCompressedSize())) {
                    assert (process) : "The CRC-32, size and compressed size properties must be set when using RDC!";
                    return new BufferedEntryOutputStream(local);
                }
                return new EntryOutputStream(local, process);
            }
        }
        return new Output();
    }

    boolean updateProperties(ZipDriverEntry local, @CheckForNull Entry peer) {
        boolean process = true;
        if (-1L == local.getTime()) {
            local.setTime(System.currentTimeMillis());
        }
        if (peer != null) {
            ZipDriverEntry zpeer;
            if (-1L == local.getSize()) {
                local.setSize(peer.getSize(Entry.Size.DATA));
            }
            if (peer instanceof ZipDriverEntry && !(process = this.driver.process(this, local, zpeer = (ZipDriverEntry)peer))) {
                local.setPlatform(zpeer.getPlatform());
                local.setEncrypted(zpeer.isEncrypted());
                local.setMethod(zpeer.getMethod());
                local.setCrc(zpeer.getCrc());
                local.setSize(zpeer.getSize());
                local.setCompressedSize(zpeer.getCompressedSize());
                local.setExtra(zpeer.getExtra());
            }
        }
        if (0L == local.getSize()) {
            process = true;
            local.clearEncryption();
            local.setMethod(0);
            local.setCrc(0L);
            local.setCompressedSize(0L);
        }
        return process;
    }

    @Override
    public final boolean isBusy() {
        return super.isBusy() || null != this.bufferedEntry;
    }

    @Override
    public void close() throws IOException {
        super.finish();
        IOPool.Entry<?> postamble = this.postamble;
        if (null != postamble) {
            this.postamble = null;
            InputSocket input = postamble.getInputSocket();
            IOException ex = null;
            try {
                InputStream in = input.newInputStream();
                try {
                    long ol = this.length();
                    long ipl = ((Entry)input.getLocalTarget()).getSize(Entry.Size.DATA);
                    if ((ol + ipl) % 4L != 0L) {
                        this.write(new byte[4 - (int)(ol % 4L)]);
                    }
                    Streams.cat((InputStream)in, (OutputStream)((Object)this));
                }
                catch (IOException ex2) {
                    ex = ex2;
                    throw ex2;
                }
                finally {
                    block23: {
                        try {
                            in.close();
                        }
                        catch (IOException ex2) {
                            if (null == ex) {
                                throw ex2;
                            }
                            if (!JSE7.AVAILABLE) break block23;
                            ex.addSuppressed(ex2);
                        }
                    }
                }
            }
            catch (IOException ex2) {
                ex = ex2;
                throw ex2;
            }
            finally {
                block24: {
                    try {
                        postamble.release();
                    }
                    catch (IOException ex2) {
                        if (null == ex) {
                            throw ex2;
                        }
                        if (!JSE7.AVAILABLE) break block24;
                        ex.addSuppressed(ex2);
                    }
                }
            }
        }
        super.close();
    }

    @CleanupObligation
    private final class BufferedEntryOutputStream
    extends DecoratingOutputStream {
        final IOPool.Entry<?> buffer;
        final ZipDriverEntry local;
        boolean closed;

        @CreatesObligation
        BufferedEntryOutputStream(ZipDriverEntry local) throws IOException {
            super(null);
            assert (0 == local.getMethod());
            this.local = local;
            IOPool.Entry buffer = this.buffer = (IOPool.Entry)ZipOutputShop.this.getIOPool().allocate();
            try {
                this.delegate = new CheckedOutputStream(buffer.getOutputSocket().newOutputStream(), new CRC32());
            }
            catch (IOException ex) {
                block5: {
                    try {
                        buffer.release();
                    }
                    catch (IOException ex2) {
                        if (!JSE7.AVAILABLE) break block5;
                        ex.addSuppressed(ex2);
                    }
                }
                throw ex;
            }
            ZipOutputShop.this.bufferedEntry = local;
        }

        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.delegate.close();
            this.updateProperties();
            this.storeBuffer();
            this.closed = true;
            ZipOutputShop.this.bufferedEntry = null;
        }

        void updateProperties() {
            ZipDriverEntry local = this.local;
            IOPool.Entry<?> buffer = this.buffer;
            local.setCrc(((CheckedOutputStream)this.delegate).getChecksum().getValue());
            long length = buffer.getSize(Entry.Size.DATA);
            local.setSize(length);
            local.setCompressedSize(length);
            ZipOutputShop.this.updateProperties(local, (Entry)buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void storeBuffer() throws IOException {
            IOPool.Entry<?> buffer = this.buffer;
            InputStream in = buffer.getInputSocket().newInputStream();
            SequentialIOExceptionBuilder builder = SequentialIOExceptionBuilder.create(IOException.class, SequentialIOException.class);
            try {
                ZipOutputShop zos = ZipOutputShop.this;
                zos.putNextEntry(this.local);
                try {
                    Streams.cat((InputStream)in, (OutputStream)((Object)zos));
                }
                catch (InputException ex2) {
                    builder.warn((Exception)((Object)ex2));
                }
                try {
                    zos.closeEntry();
                }
                catch (IOException ex2) {
                    builder.warn((Exception)ex2);
                }
                builder.check();
            }
            catch (IOException ex) {
                builder.warn((Exception)ex);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    builder.warn((Exception)ex);
                }
            }
            builder.check();
            buffer.release();
        }
    }

    @CleanupObligation
    private final class EntryOutputStream
    extends DecoratingOutputStream {
        boolean closed;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        EntryOutputStream(ZipDriverEntry entry, boolean process) throws IOException {
            super((OutputStream)((Object)ZipOutputShop.this));
            ZipOutputShop.this.putNextEntry(entry, process);
        }

        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            ZipOutputShop.this.closeEntry();
            this.closed = true;
        }
    }

    private static final class DirectoryTemplate
    implements Entry {
        static final DirectoryTemplate INSTANCE = new DirectoryTemplate();

        private DirectoryTemplate() {
        }

        public String getName() {
            return "/";
        }

        public long getSize(Entry.Size type) {
            return 0L;
        }

        public long getTime(Entry.Access type) {
            return -1L;
        }
    }
}

