/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.entry.EntryContainer;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemEvent;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemException;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemOperation;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemTouchListener;
import de.schlichtherle.truezip.fs.archive.FsCovariantEntry;
import de.schlichtherle.truezip.fs.archive.FsReadOnlyArchiveFileSystem;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.HashMaps;
import de.schlichtherle.truezip.util.Link;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class FsArchiveFileSystem<E extends FsArchiveEntry>
implements Iterable<FsCovariantEntry<E>> {
    private static final String ROOT_PATH = FsEntryName.ROOT.getPath();
    private final Splitter splitter = new Splitter();
    private final FsArchiveDriver<E> factory;
    private final EntryTable<E> master;
    private boolean touched;
    @CheckForNull
    private FsArchiveFileSystemTouchListener<? super E> touchListener;

    static <E extends FsArchiveEntry> FsArchiveFileSystem<E> newEmptyFileSystem(FsArchiveDriver<E> driver) {
        return new FsArchiveFileSystem<E>(driver);
    }

    private FsArchiveFileSystem(FsArchiveDriver<E> driver) {
        this.factory = driver;
        E root = this.newEntry(ROOT_PATH, Entry.Type.DIRECTORY, FsOutputOptions.NONE, null);
        long time = System.currentTimeMillis();
        for (Entry.Access access : Entry.ALL_ACCESS_SET) {
            root.setTime(access, time);
        }
        EntryTable<E> master = new EntryTable<E>(HashMaps.initialCapacity(47));
        master.add(ROOT_PATH, root);
        this.master = master;
        this.touched = true;
    }

    static <E extends FsArchiveEntry> FsArchiveFileSystem<E> newPopulatedFileSystem(FsArchiveDriver<E> driver, @WillNotClose EntryContainer<E> archive, @CheckForNull Entry rootTemplate, boolean readOnly) throws FsArchiveFileSystemException {
        return readOnly ? new FsReadOnlyArchiveFileSystem<E>(archive, driver, rootTemplate) : new FsArchiveFileSystem<E>(driver, archive, rootTemplate);
    }

    FsArchiveFileSystem(FsArchiveDriver<E> driver, @WillNotClose EntryContainer<E> archive, @CheckForNull Entry rootTemplate) throws FsArchiveFileSystemException {
        this.factory = driver;
        EntryTable<FsArchiveEntry> master = new EntryTable<FsArchiveEntry>(HashMaps.initialCapacity(archive.getSize() + 47));
        ArrayList<String> paths = new ArrayList<String>(archive.getSize());
        Paths.Normalizer normalizer = new Paths.Normalizer('/');
        for (FsArchiveEntry entry : archive) {
            String path = Paths.cutTrailingSeparators(normalizer.normalize(entry.getName().replace('\\', '/')), '/');
            master.add(path, entry);
            if (path.startsWith("/") || "../".startsWith(path.substring(0, Math.min(3, path.length())))) continue;
            paths.add(path);
        }
        master.add(ROOT_PATH, (FsArchiveEntry)this.newEntry(ROOT_PATH, Entry.Type.DIRECTORY, FsOutputOptions.NONE, rootTemplate));
        this.master = master;
        for (String path : paths) {
            this.fix(path);
        }
    }

    private void fix(String name) throws FsArchiveFileSystemException {
        if (Paths.isRoot(name)) {
            return;
        }
        this.splitter.split(name);
        String parentPath = this.splitter.getParentPath();
        String memberName = this.splitter.getMemberName();
        FsCovariantEntry<E> parent = this.master.get(parentPath);
        if (null == parent || !parent.isType(Entry.Type.DIRECTORY)) {
            parent = this.master.add(parentPath, this.newCheckedEntry(parentPath, Entry.Type.DIRECTORY, FsOutputOptions.NONE, null));
        }
        parent.add(memberName);
        this.fix(parentPath);
    }

    boolean isReadOnly() {
        return false;
    }

    private void touch() throws IOException {
        if (this.touched) {
            return;
        }
        FsArchiveFileSystemEvent e = new FsArchiveFileSystemEvent(this);
        FsArchiveFileSystemTouchListener tl = this.touchListener;
        if (null != tl) {
            tl.beforeTouch(e);
        }
        this.touched = true;
        if (null != tl) {
            tl.afterTouch(e);
        }
    }

    final FsArchiveFileSystemTouchListener<? super E>[] getFsArchiveFileSystemTouchListeners() {
        FsArchiveFileSystemTouchListener[] fsArchiveFileSystemTouchListenerArray;
        if (null == this.touchListener) {
            fsArchiveFileSystemTouchListenerArray = new FsArchiveFileSystemTouchListener[]{};
        } else {
            FsArchiveFileSystemTouchListener[] fsArchiveFileSystemTouchListenerArray2 = new FsArchiveFileSystemTouchListener[1];
            fsArchiveFileSystemTouchListenerArray = fsArchiveFileSystemTouchListenerArray2;
            fsArchiveFileSystemTouchListenerArray2[0] = this.touchListener;
        }
        return fsArchiveFileSystemTouchListenerArray;
    }

    final void addFsArchiveFileSystemTouchListener(FsArchiveFileSystemTouchListener<? super E> listener) throws TooManyListenersException {
        if (null == listener) {
            throw new NullPointerException();
        }
        if (null != this.touchListener) {
            throw new TooManyListenersException();
        }
        this.touchListener = listener;
    }

    final void removeFsArchiveFileSystemTouchListener(FsArchiveFileSystemTouchListener<? super E> listener) {
        if (null == listener) {
            throw new NullPointerException();
        }
        if (this.touchListener == listener) {
            this.touchListener = null;
        }
    }

    int getSize() {
        return this.master.getSize();
    }

    @Override
    public Iterator<FsCovariantEntry<E>> iterator() {
        return this.master.iterator();
    }

    @Nullable
    final FsCovariantEntry<E> getEntry(FsEntryName name) {
        FsCovariantEntry<E> entry = this.master.get(name.getPath());
        return null == entry ? null : entry.clone(this.factory);
    }

    private E newEntry(String name, Entry.Type type, BitField<FsOutputOption> mknod, @CheckForNull Entry template) {
        assert (null != type);
        assert (!Paths.isRoot(name) || Entry.Type.DIRECTORY == type);
        try {
            return this.factory.newEntry(name, type, template, mknod);
        }
        catch (CharConversionException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private E newCheckedEntry(String name, Entry.Type type, BitField<FsOutputOption> mknod, @CheckForNull Entry template) throws FsArchiveFileSystemException {
        assert (null != type);
        assert (!Paths.isRoot(name) || Entry.Type.DIRECTORY == type);
        try {
            this.factory.assertEncodable(name);
            return this.factory.newEntry(name, type, template, mknod);
        }
        catch (CharConversionException ex) {
            throw new FsArchiveFileSystemException(name, ex);
        }
    }

    FsArchiveFileSystemOperation<E> mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, @CheckForNull Entry template) throws FsArchiveFileSystemException {
        if (null == type) {
            throw new NullPointerException();
        }
        if (Entry.Type.FILE != type && Entry.Type.DIRECTORY != type) {
            throw new FsArchiveFileSystemException(name, "only FILE and DIRECTORY entries are supported");
        }
        String path = name.getPath();
        FsCovariantEntry<E> oldEntry = this.master.get(path);
        if (null != oldEntry) {
            if (!oldEntry.isType(Entry.Type.FILE)) {
                throw new FsArchiveFileSystemException(name, "only files can get replaced");
            }
            if (Entry.Type.FILE != type) {
                throw new FsArchiveFileSystemException(name, "entry exists as a different type");
            }
            if (options.get(FsOutputOption.EXCLUSIVE)) {
                throw new FsArchiveFileSystemException(name, "entry exists already");
            }
        }
        while (template instanceof FsCovariantEntry) {
            template = ((FsCovariantEntry)template).getEntry(type);
        }
        return new PathLink(path, type, options, template);
    }

    void unlink(FsEntryName name) throws IOException {
        int size;
        String path = name.getPath();
        FsCovariantEntry<E> ce = this.master.get(path);
        if (null == ce) {
            throw new FsArchiveFileSystemException(name, "archive entry does not exist");
        }
        if (ce.isType(Entry.Type.DIRECTORY) && 0 != (size = ce.getMembers().size())) {
            throw new FsArchiveFileSystemException(name, String.format("directory not empty - contains %d member(s)", size));
        }
        if (name.isRoot()) {
            return;
        }
        this.touch();
        this.master.remove(path);
        E ae = ce.getEntry();
        for (Entry.Size size2 : Entry.ALL_SIZE_SET) {
            ae.setSize(size2, -1L);
        }
        for (Entry.Access access : Entry.ALL_ACCESS_SET) {
            ae.setTime(access, -1L);
        }
        this.splitter.split(path);
        String parentPath = this.splitter.getParentPath();
        FsCovariantEntry<E> pce = this.master.get(parentPath);
        assert (null != pce) : "The parent directory of \"" + name.toString() + "\" is missing - archive file system is corrupted!";
        boolean bl = pce.remove(this.splitter.getMemberName());
        assert (bl) : "The parent directory of \"" + name.toString() + "\" does not contain this entry - archive file system is corrupted!";
        E pae = pce.getEntry(Entry.Type.DIRECTORY);
        if (-1L != pae.getTime(Entry.Access.WRITE)) {
            pae.setTime(Entry.Access.WRITE, System.currentTimeMillis());
        }
    }

    boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value) throws IOException {
        if (0L > value) {
            throw new IllegalArgumentException(name.toString() + " (negative access time)");
        }
        FsCovariantEntry<E> ce = this.master.get(name.getPath());
        if (null == ce) {
            throw new FsArchiveFileSystemException(name, "archive entry not found");
        }
        this.touch();
        E ae = ce.getEntry();
        boolean ok = true;
        for (Entry.Access type : types) {
            ok &= ae.setTime(type, value);
        }
        return ok;
    }

    boolean setTime(FsEntryName name, Map<Entry.Access, Long> times) throws IOException {
        FsCovariantEntry<E> ce = this.master.get(name.getPath());
        if (null == ce) {
            throw new FsArchiveFileSystemException(name, "archive entry not found");
        }
        this.touch();
        E ae = ce.getEntry();
        boolean ok = true;
        for (Map.Entry<Entry.Access, Long> time : times.entrySet()) {
            long value = time.getValue();
            ok &= 0L <= value && ae.setTime(time.getKey(), value);
        }
        return ok;
    }

    boolean isWritable(FsEntryName name) {
        return !this.isReadOnly();
    }

    void setReadOnly(FsEntryName name) throws FsArchiveFileSystemException {
        if (!this.isReadOnly()) {
            throw new FsArchiveFileSystemException(name, "cannot set read-only state");
        }
    }

    private static final class Splitter
    extends Paths.Splitter {
        Splitter() {
            super('/', false);
        }

        @Override
        public String getParentPath() {
            String path = super.getParentPath();
            return null != path ? path : ROOT_PATH;
        }
    }

    private static final class EntryTable<E extends FsArchiveEntry> {
        final Map<String, FsCovariantEntry<E>> map;

        EntryTable(int initialCapacity) {
            this.map = new LinkedHashMap<String, FsCovariantEntry<E>>(initialCapacity);
        }

        int getSize() {
            return this.map.size();
        }

        Iterator<FsCovariantEntry<E>> iterator() {
            return Collections.unmodifiableCollection(this.map.values()).iterator();
        }

        FsCovariantEntry<E> add(String path, E ae) {
            FsCovariantEntry<E> ce = this.map.get(path);
            if (null == ce) {
                ce = new FsCovariantEntry(path);
                this.map.put(path, ce);
            }
            ce.putEntry(ae.getType(), ae);
            return ce;
        }

        @Nullable
        FsCovariantEntry<E> get(String path) {
            return this.map.get(path);
        }

        @Nullable
        FsCovariantEntry<E> remove(String path) {
            return this.map.remove(path);
        }
    }

    private static final class SegmentLink<E extends FsArchiveEntry>
    implements Link<FsCovariantEntry<E>> {
        @Nullable
        final String base;
        final FsCovariantEntry<E> entry;

        SegmentLink(@CheckForNull String base, FsCovariantEntry<E> entry) {
            this.entry = entry;
            this.base = base;
        }

        @Override
        public FsCovariantEntry<E> getTarget() {
            return this.entry;
        }
    }

    private final class PathLink
    implements FsArchiveFileSystemOperation<E> {
        final boolean createParents;
        final BitField<FsOutputOption> options;
        final SegmentLink<E>[] links;
        long time = -1L;

        PathLink(String path, Entry.Type type, @CheckForNull BitField<FsOutputOption> options, Entry template) throws FsArchiveFileSystemException {
            this.createParents = options.get(FsOutputOption.CREATE_PARENTS);
            this.options = options.clear(FsOutputOption.CREATE_PARENTS);
            this.links = this.newSegmentLinks(1, path, type, template);
        }

        private SegmentLink<E>[] newSegmentLinks(int level, String entryName, Entry.Type entryType, @CheckForNull Entry template) throws FsArchiveFileSystemException {
            SegmentLink[] elements;
            FsArchiveFileSystem.this.splitter.split(entryName);
            String parentPath = FsArchiveFileSystem.this.splitter.getParentPath();
            String memberName = FsArchiveFileSystem.this.splitter.getMemberName();
            FsCovariantEntry parentEntry = FsArchiveFileSystem.this.master.get(parentPath);
            if (null != parentEntry) {
                if (!parentEntry.isType(Entry.Type.DIRECTORY)) {
                    throw new FsArchiveFileSystemException(entryName, "parent entry must be a directory");
                }
                elements = new SegmentLink[level + 1];
                elements[0] = new SegmentLink(null, parentEntry);
                FsCovariantEntry<FsArchiveEntry> newEntry = new FsCovariantEntry<FsArchiveEntry>(entryName);
                newEntry.putEntry(entryType, FsArchiveFileSystem.this.newCheckedEntry(entryName, entryType, this.options, template));
                elements[1] = new SegmentLink(memberName, newEntry);
            } else if (this.createParents) {
                elements = this.newSegmentLinks(level + 1, parentPath, Entry.Type.DIRECTORY, null);
                FsCovariantEntry<FsArchiveEntry> newEntry = new FsCovariantEntry<FsArchiveEntry>(entryName);
                newEntry.putEntry(entryType, FsArchiveFileSystem.this.newCheckedEntry(entryName, entryType, this.options, template));
                elements[elements.length - level] = new SegmentLink(memberName, newEntry);
            } else {
                throw new FsArchiveFileSystemException(entryName, "missing parent directory entry");
            }
            return elements;
        }

        @Override
        public void commit() throws IOException {
            assert (2 <= this.links.length);
            FsArchiveFileSystem.this.touch();
            int l = this.links.length;
            FsCovariantEntry parentCE = this.links[0].entry;
            Object parentAE = parentCE.getEntry(Entry.Type.DIRECTORY);
            for (int i = 1; i < l; ++i) {
                SegmentLink link = this.links[i];
                FsCovariantEntry entryCE = link.entry;
                Object entryAE = entryCE.getEntry();
                String member = link.base;
                FsArchiveFileSystem.this.master.add(entryCE.getName(), entryAE);
                if (FsArchiveFileSystem.this.master.get(parentCE.getName()).add(member) && -1L != parentAE.getTime(Entry.Access.WRITE)) {
                    parentAE.setTime(Entry.Access.WRITE, this.getCurrentTimeMillis());
                }
                parentCE = entryCE;
                parentAE = entryAE;
            }
            if (-1L == parentAE.getTime(Entry.Access.WRITE)) {
                parentAE.setTime(Entry.Access.WRITE, this.getCurrentTimeMillis());
            }
        }

        private long getCurrentTimeMillis() {
            return -1L != this.time ? this.time : (this.time = System.currentTimeMillis());
        }

        @Override
        public FsCovariantEntry<E> getTarget() {
            return this.links[this.links.length - 1].getTarget();
        }
    }
}

