/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import de.siegmar.logbackgelf.AbstractGelfAppender;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;

public class GelfTcpAppender
extends AbstractGelfAppender {
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int DEFAULT_RECONNECT_INTERVAL = 300;
    private static final int DEFAULT_MAX_RETRIES = 2;
    private static final int DEFAULT_RETRY_DELAY = 3000;
    private static final int SEC_TO_MSEC = 1000;
    private final Object lock = new Object();
    private int connectTimeout = 15000;
    private int reconnectInterval = 300;
    private int maxRetries = 2;
    private int retryDelay = 3000;
    private OutputStream outputStream;
    private long nextReconnect;

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(int reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
    }

    @Override
    protected void appendMessage(byte[] messageToSend) throws IOException {
        byte[] tcpMessage = Arrays.copyOf(messageToSend, messageToSend.length + 1);
        int openRetries = this.maxRetries;
        while (!this.sendMessage(tcpMessage)) {
            if (this.retryDelay > 0 && openRetries > 0) {
                try {
                    Thread.sleep(this.retryDelay);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            if (openRetries-- > 0 && this.isStarted()) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendMessage(byte[] messageToSend) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (System.currentTimeMillis() > this.nextReconnect) {
                    this.connect();
                }
                this.outputStream.write(messageToSend);
                return true;
            }
            catch (IOException e) {
                this.addError(String.format("Error sending message via tcp://%s:%s", this.getGraylogHost(), this.getGraylogPort()), e);
                this.nextReconnect = 0L;
            }
        }
        return false;
    }

    private void connect() throws IOException {
        this.closeOut();
        Socket socket = this.getSocket();
        this.outputStream = socket.getOutputStream();
        this.nextReconnect = this.reconnectInterval < 0 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)(this.reconnectInterval * 1000);
    }

    protected Socket getSocket() throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(this.getGraylogHost(), this.getGraylogPort()), this.connectTimeout);
        socket.shutdownInput();
        return socket;
    }

    private void closeOut() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                this.addError("Can't close stream", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.closeOut();
        }
    }
}

