/*
 * Decompiled with CFR 0.152.
 */
package de.svenkubiak.embeddedmongodb;

import com.mongodb.MongoClient;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.svenkubiak.embeddedmongodb.EmbeddedMongoRunnable;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.slf4j.LoggerFactory;

public enum EmbeddedMongo {
    DB;

    private static final int MIN_PORT = 1025;
    private static final int MAX_PORT = 50000;
    private static final String ALGORITHM = "SHA1PRNG";
    private static final String LOCALHOST = "localhost";
    private EmbeddedMongoRunnable runnable;
    private MongodProcess mongodProcess;
    private boolean active = false;
    private boolean mongoThreaded;
    private boolean mongoIPv6;
    private String mongoHost;
    private int mongoPort;

    private EmbeddedMongo() {
        try {
            this.mongoPort = SecureRandom.getInstance(ALGORITHM).nextInt(50000) + 1025;
            this.mongoHost = LOCALHOST;
            this.mongoThreaded = false;
            this.mongoIPv6 = false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LoggerFactory.getLogger(EmbeddedMongo.class).error("Failed to init EmbeddedMongo", (Throwable)noSuchAlgorithmException);
        }
    }

    public EmbeddedMongo port(int n) {
        this.mongoPort = n;
        return this;
    }

    public EmbeddedMongo host(String string) {
        this.mongoHost = string;
        return this;
    }

    public EmbeddedMongo threaded(boolean bl) {
        this.mongoThreaded = bl;
        return this;
    }

    public EmbeddedMongo ipv6(boolean bl) {
        this.mongoIPv6 = bl;
        return this;
    }

    public void start() {
        if (!this.active) {
            Net net = new Net(this.mongoHost, this.mongoPort, this.mongoIPv6);
            if (this.mongoThreaded) {
                this.runnable = new EmbeddedMongoRunnable(net);
                Thread thread = new Thread(this.runnable);
                thread.start();
                this.active = true;
            } else {
                try {
                    this.mongodProcess = (MongodProcess)((MongodExecutable)MongodStarter.getDefaultInstance().prepare((IExecutableProcessConfig)new MongodConfigBuilder().version((IFeatureAwareVersion)Version.Main.V3_0).net(net).build())).start();
                    LoggerFactory.getLogger(EmbeddedMongo.class).info("Successfully created EmbeddedMongo @ {}:{}", (Object)LOCALHOST, (Object)this.mongoPort);
                    this.active = true;
                }
                catch (IOException iOException) {
                    LoggerFactory.getLogger(EmbeddedMongo.class).error("Failed to start EmbeddedMongo", (Throwable)iOException);
                }
            }
        }
    }

    public void stop() {
        if (this.active) {
            if (this.mongoThreaded) {
                this.runnable.shutdown();
            } else {
                this.mongodProcess.stop();
            }
            this.active = false;
        }
    }

    public MongoClient getMongoClient() {
        return new MongoClient(this.getHost(), this.getPort());
    }

    public int getPort() {
        return this.mongoPort;
    }

    public String getHost() {
        return this.mongoHost;
    }

    public boolean isThreaded() {
        return this.mongoThreaded;
    }

    public boolean isIPv6() {
        return this.mongoIPv6;
    }
}

