/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.org.apache.http.impl.entity;

import de.undercouch.gradle.tasks.download.org.apache.http.HttpException;
import de.undercouch.gradle.tasks.download.org.apache.http.HttpMessage;
import de.undercouch.gradle.tasks.download.org.apache.http.ProtocolException;
import de.undercouch.gradle.tasks.download.org.apache.http.annotation.Contract;
import de.undercouch.gradle.tasks.download.org.apache.http.annotation.ThreadingBehavior;
import de.undercouch.gradle.tasks.download.org.apache.http.entity.ContentLengthStrategy;
import de.undercouch.gradle.tasks.download.org.apache.http.impl.entity.LaxContentLengthStrategy;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

