/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.messagesets;

import de.vandermeer.skb.interfaces.messagesets.IsErrorSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public interface IsErrorSetFT
extends IsErrorSet<FormattingTuple> {
    default public void addAllErrors(IsErrorSetFT errors) {
        this.getErrorMessages().addAll(errors.getErrorMessages());
    }

    @Override
    default public void addError(String error) {
        Validate.notBlank((CharSequence)error);
        this.addError(MessageFormatter.arrayFormat((String)error, (Object[])new Object[0]));
    }

    default public void addError(String error, Object ... obj) {
        Validate.notBlank((CharSequence)error);
        Validate.notNull((Object)obj);
        Validate.noNullElements((Object[])obj);
        this.addError(MessageFormatter.arrayFormat((String)error, (Object[])obj));
    }

    @Override
    default public String render() {
        StrBuilder ret = new StrBuilder(100);
        for (FormattingTuple ft : this.getErrorMessages()) {
            ret.append(ft.getMessage()).appendNewLine();
        }
        return ret.toString();
    }

    public static IsErrorSetFT create() {
        return new IsErrorSetFT(){
            final Set<FormattingTuple> errorSet = new LinkedHashSet<FormattingTuple>();

            @Override
            public Set<FormattingTuple> getErrorMessages() {
                return this.errorSet;
            }
        };
    }
}

