/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.CacheLocations;
import dev.equo.solstice.p2.JarCache;
import dev.equo.solstice.p2.LockFile;
import dev.equo.solstice.p2.OfflineCache;
import dev.equo.solstice.p2.P2ClientCache;
import dev.equo.solstice.p2.P2Session;
import dev.equo.solstice.p2.P2Unit;
import dev.equo.solstice.p2.Unchecked;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import okhttp3.Cache;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.tukaani.xz.XZInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class P2Client
implements AutoCloseable {
    private final Cache metadataResponseCache;
    private final OkHttpClient metadataClient;
    private final P2ClientCache cachingPolicy;
    private final OfflineCache offlineMetadataCache;
    private final JarCache jarCache;
    private final LockFile lock;
    private static final String CONTENT_XML = "content.xml";
    private static final String COMPOSITE_XML = "compositeContent.xml";
    private static final byte[] DOCTYPE_HTML = "<!doctype html>".getBytes(StandardCharsets.UTF_8);
    private static final Pattern p2metadata = Pattern.compile("metadata\\.repository\\.factory\\.order\\s*=(.*),");

    public P2Client() throws IOException {
        this(P2ClientCache.PREFER_OFFLINE);
    }

    public P2Client(P2ClientCache cachingPolicy) throws IOException {
        this.cachingPolicy = cachingPolicy;
        this.jarCache = new JarCache(cachingPolicy);
        long maxSize = 0x3200000L;
        File p2metadata = CacheLocations.p2metadata();
        if (cachingPolicy.cacheAllowed()) {
            this.metadataResponseCache = new Cache(new File(p2metadata, "connection"), maxSize);
            this.metadataClient = new OkHttpClient.Builder().cache(this.metadataResponseCache).build();
        } else {
            this.metadataResponseCache = null;
            this.metadataClient = new OkHttpClient.Builder().build();
        }
        this.offlineMetadataCache = new OfflineCache(new File(p2metadata, "offline"));
        this.lock = new LockFile(p2metadata);
    }

    public File download(P2Unit unit) throws IOException {
        return this.jarCache.download(unit);
    }

    @Override
    public void close() throws IOException {
        if (this.metadataResponseCache != null) {
            this.metadataResponseCache.close();
        }
        this.lock.close();
    }

    void addUnits(P2Session session, String url) throws Exception {
        Unchecked.ThrowingConsumer<Folder> addUnits = root -> {
            if (!root.metadataName.equals(CONTENT_XML)) {
                throw new IllegalArgumentException("Expected endsWith /content.xml but was " + root.url + root.metadataName);
            }
            String contentXml = this.resolveXml(root.url, root.metadataName);
            P2Client.parseContentXml(session, root, contentXml);
        };
        ArrayDeque<Folder> queue = new ArrayDeque<Folder>();
        queue.push(new Folder(url));
        while (!queue.isEmpty()) {
            Folder dir = (Folder)queue.pop();
            if (!dir.isComposite()) {
                addUnits.accept(new Folder(dir.url, dir.metadataName));
                continue;
            }
            List<String> children = P2Client.parseComposite(this.resolveXml(dir.url, dir.metadataName));
            for (String child : children) {
                if (child.startsWith("https://") || child.startsWith("http://")) {
                    queue.push(new Folder(child + "/"));
                    continue;
                }
                if (child.startsWith("file:")) {
                    child = child.substring("file:".length());
                }
                queue.push(new Folder(dir.url + child + "/"));
            }
        }
    }

    private String getString(String url) throws IOException, NotFoundException {
        return new String(this.getBytes(url), StandardCharsets.UTF_8);
    }

    private static boolean contentIsHtml(byte[] content) {
        if (content.length <= DOCTYPE_HTML.length) {
            return false;
        }
        for (int i = 0; i < DOCTYPE_HTML.length; ++i) {
            if (content[i] == DOCTYPE_HTML[i]) continue;
            return false;
        }
        return true;
    }

    static Request buildRequest(String url) {
        String[] info = null;
        try {
            URL netUrl = new URL(url);
            String userInfo = netUrl.getUserInfo();
            if (userInfo != null) {
                info = userInfo.split(":");
            }
        }
        catch (Exception netUrl) {
            // empty catch block
        }
        Request.Builder builder = new Request.Builder().url(url);
        if (info != null && info.length == 2) {
            String credential = Credentials.basic((String)info[0], (String)info[1]);
            builder.addHeader("Authorization", credential);
        }
        return builder.build();
    }

    private byte[] getBytes(String url) throws IOException, NotFoundException {
        byte[] cached;
        if (this.cachingPolicy.tryOfflineFirst() && (cached = this.offlineMetadataCache.get(url)) != null) {
            if (OfflineCache.is404(cached)) {
                throw new NotFoundException(url);
            }
            return cached;
        }
        if (this.cachingPolicy.networkAllowed()) {
            byte[] byArray;
            block19: {
                Request request = P2Client.buildRequest(url);
                Response response = this.metadataClient.newCall(request).execute();
                try {
                    if (response.code() == 404) {
                        if (this.cachingPolicy.cacheAllowed()) {
                            this.offlineMetadataCache.put404(url);
                        }
                        throw new NotFoundException(url);
                    }
                    if (response.code() == 502) {
                        System.err.println("Received 502 from " + url);
                        throw new IOException("Received 502 from " + url);
                    }
                    byte[] bytes = response.body().bytes();
                    if (P2Client.contentIsHtml(bytes)) {
                        if (this.cachingPolicy.cacheAllowed()) {
                            this.offlineMetadataCache.put404(url);
                        }
                        throw new NotFoundException(url);
                    }
                    if (this.cachingPolicy.cacheAllowed()) {
                        this.offlineMetadataCache.put(url, bytes);
                    }
                    byArray = bytes;
                    if (response == null) break block19;
                }
                catch (Throwable bytes) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                bytes.addSuppressed(throwable);
                            }
                        }
                        throw bytes;
                    }
                    catch (UnknownHostException e) {
                        byte[] cached2;
                        if (this.cachingPolicy.cacheAllowed() && (cached2 = this.offlineMetadataCache.get(url)) != null) {
                            if (OfflineCache.is404(cached2)) {
                                throw new NotFoundException(url);
                            }
                            return cached2;
                        }
                        throw e;
                    }
                }
                response.close();
            }
            return byArray;
        }
        throw new IllegalStateException("P2Client is in offline mode but has no cache for " + url);
    }

    private static String getGroup1(String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        matcher.find();
        return matcher.group(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String resolveXml(String url, String metadataTarget) throws IOException {
        if (!metadataTarget.endsWith(".xml")) {
            throw new IllegalArgumentException("Expected to end with .xml, was " + metadataTarget);
        }
        String xzUrl = url + metadataTarget + ".xz";
        String jarUrl = url + metadataTarget.substring(0, metadataTarget.length() - ".xml".length()) + ".jar";
        String rawUrl = url + metadataTarget;
        try {
            byte[] bytes = this.getBytes(xzUrl);
            try (XZInputStream stream = new XZInputStream((InputStream)new ByteArrayInputStream(bytes));){
                String string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                return string;
            }
        }
        catch (NotFoundException bytes) {
            try {
                byte[] bytes2 = this.getBytes(jarUrl);
                ArrayList<String> unwantedEntries = new ArrayList<String>();
                try (ZipInputStream zipStream = new ZipInputStream(new ByteArrayInputStream(bytes2));){
                    ZipEntry entry;
                    while ((entry = zipStream.getNextEntry()) != null) {
                        if (entry.getName().equals(metadataTarget)) {
                            String string = new String(zipStream.readAllBytes(), StandardCharsets.UTF_8);
                            return string;
                        }
                        unwantedEntries.add(entry.getName());
                    }
                    throw new IllegalArgumentException("Expected to find " + metadataTarget + " but was " + unwantedEntries);
                }
            }
            catch (NotFoundException notFoundException) {
                try {
                    return new String(this.getBytes(rawUrl), StandardCharsets.UTF_8);
                }
                catch (NotFoundException notFoundException2) {
                    throw new CouldNotFindException(xzUrl, jarUrl, rawUrl);
                }
            }
        }
    }

    private static List<String> parseComposite(String content) throws Exception {
        return P2Client.parseDocument(content, doc -> {
            ArrayList<String> childLocations = new ArrayList<String>();
            Node childrenNode = doc.getDocumentElement().getElementsByTagName("children").item(0);
            NodeList children = childrenNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (!"child".equals(node.getNodeName())) continue;
                String location = node.getAttributes().getNamedItem("location").getNodeValue();
                childLocations.add(location);
            }
            return childLocations;
        });
    }

    private static void parseContentXml(P2Session session, Folder folder, String content) throws Exception {
        P2Client.parseDocument(content, doc -> {
            NodeList unitNodes = doc.getDocumentElement().getElementsByTagName("units").item(0).getChildNodes();
            for (int i = 0; i < unitNodes.getLength(); ++i) {
                Node node = unitNodes.item(i);
                if (!"unit".equals(node.getNodeName())) continue;
                session.units.add(new P2Unit(session, folder, node));
            }
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T parseDocument(String content, Function<Document, T> parser) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            Document doc = db.parse(stream);
            Document t = parser.apply(doc);
            return (T)t;
        }
        catch (Exception e) {
            System.err.println("/ERROR WHILE PARSING BELOW");
            System.err.println(content);
            System.err.println("\\ERROR WHILE PARSING ABOVE");
            throw e;
        }
    }

    private static class CouldNotFindException
    extends IllegalArgumentException {
        final List<String> triedUrls;

        CouldNotFindException(String ... triedUrls) {
            super("Attempted to find resource at\n" + String.join((CharSequence)"\n", triedUrls));
            this.triedUrls = Arrays.asList(triedUrls);
        }
    }

    class Folder {
        final String url;
        final String metadataName;

        Folder(String url) throws IOException, NotFoundException {
            String metadataTarget;
            if (!url.endsWith("/")) {
                throw new IllegalArgumentException("URL needs to end with /" + url);
            }
            this.url = url;
            String p2IndexContent = null;
            try {
                p2IndexContent = P2Client.this.getString(url + "p2.index");
                metadataTarget = P2Client.getGroup1(p2IndexContent, p2metadata).trim();
            }
            catch (IllegalStateException e) {
                throw new UnsupportedOperationException("We could not parse the content at " + url + "p2.index:\n\n" + p2IndexContent, e);
            }
            catch (NotFoundException e) {
                metadataTarget = null;
            }
            if (metadataTarget == null) {
                String guessedXml = null;
                ArrayList<Object> triedUrls = new ArrayList<Object>();
                triedUrls.add(url + "p2.index");
                try {
                    P2Client.this.resolveXml(url, P2Client.CONTENT_XML);
                    guessedXml = P2Client.CONTENT_XML;
                }
                catch (CouldNotFindException e) {
                    triedUrls.addAll(e.triedUrls);
                    try {
                        P2Client.this.resolveXml(url, P2Client.COMPOSITE_XML);
                        guessedXml = P2Client.COMPOSITE_XML;
                    }
                    catch (CouldNotFindException e2) {
                        triedUrls.addAll(e2.triedUrls);
                    }
                }
                if (guessedXml == null) {
                    throw new CouldNotFindException(triedUrls.toArray(new String[0]));
                }
                this.metadataName = guessedXml;
            } else {
                this.metadataName = metadataTarget.indexOf(44) == -1 ? metadataTarget : Arrays.stream(metadataTarget.split(",")).map(String::trim).filter(s -> s.endsWith(".xml")).findFirst().get();
            }
        }

        Folder(String url, String metadataTarget) {
            if (!url.endsWith("/")) {
                throw new IllegalArgumentException("URL needs to end with /" + url);
            }
            this.url = url;
            this.metadataName = metadataTarget;
        }

        private boolean isComposite() {
            return this.metadataName.startsWith("composite");
        }
    }

    static class NotFoundException
    extends Exception {
        NotFoundException(String url) {
            super(url);
        }
    }
}

