/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic.internal.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import dev.langchain4j.model.anthropic.internal.api.AnthropicMessage;
import dev.langchain4j.model.anthropic.internal.api.AnthropicTool;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolChoice;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AnthropicCreateMessageRequest {
    public String model;
    public List<AnthropicMessage> messages;
    public String system;
    public int maxTokens;
    public List<String> stopSequences;
    public boolean stream;
    public Double temperature;
    public Double topP;
    public Integer topK;
    public List<AnthropicTool> tools;
    public AnthropicToolChoice toolChoice;

    public static AnthropicCreateMessageRequestBuilder builder() {
        return new AnthropicCreateMessageRequestBuilder();
    }

    public AnthropicCreateMessageRequestBuilder toBuilder() {
        return new AnthropicCreateMessageRequestBuilder().model(this.model).messages(this.messages).system(this.system).maxTokens(this.maxTokens).stopSequences(this.stopSequences).stream(this.stream).temperature(this.temperature).topP(this.topP).topK(this.topK).tools(this.tools).toolChoice(this.toolChoice);
    }

    public String getModel() {
        return this.model;
    }

    public List<AnthropicMessage> getMessages() {
        return this.messages;
    }

    public String getSystem() {
        return this.system;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public boolean isStream() {
        return this.stream;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public List<AnthropicTool> getTools() {
        return this.tools;
    }

    public AnthropicToolChoice getToolChoice() {
        return this.toolChoice;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setMessages(List<AnthropicMessage> messages) {
        this.messages = messages;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setMaxTokens(int maxTokens) {
        this.maxTokens = maxTokens;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public void setTools(List<AnthropicTool> tools) {
        this.tools = tools;
    }

    public void setToolChoice(AnthropicToolChoice toolChoice) {
        this.toolChoice = toolChoice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnthropicCreateMessageRequest)) {
            return false;
        }
        AnthropicCreateMessageRequest other = (AnthropicCreateMessageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxTokens() != other.getMaxTokens()) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$topK = this.getTopK();
        Integer other$topK = other.getTopK();
        if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<AnthropicMessage> this$messages = this.getMessages();
        List<AnthropicMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$system = this.getSystem();
        String other$system = other.getSystem();
        if (this$system == null ? other$system != null : !this$system.equals(other$system)) {
            return false;
        }
        List<String> this$stopSequences = this.getStopSequences();
        List<String> other$stopSequences = other.getStopSequences();
        if (this$stopSequences == null ? other$stopSequences != null : !((Object)this$stopSequences).equals(other$stopSequences)) {
            return false;
        }
        List<AnthropicTool> this$tools = this.getTools();
        List<AnthropicTool> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        AnthropicToolChoice this$toolChoice = this.getToolChoice();
        AnthropicToolChoice other$toolChoice = other.getToolChoice();
        return !(this$toolChoice == null ? other$toolChoice != null : !this$toolChoice.equals(other$toolChoice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnthropicCreateMessageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxTokens();
        result = result * 59 + (this.isStream() ? 79 : 97);
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $topK = this.getTopK();
        result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<AnthropicMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $system = this.getSystem();
        result = result * 59 + ($system == null ? 43 : $system.hashCode());
        List<String> $stopSequences = this.getStopSequences();
        result = result * 59 + ($stopSequences == null ? 43 : ((Object)$stopSequences).hashCode());
        List<AnthropicTool> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        AnthropicToolChoice $toolChoice = this.getToolChoice();
        result = result * 59 + ($toolChoice == null ? 43 : $toolChoice.hashCode());
        return result;
    }

    public String toString() {
        return "AnthropicCreateMessageRequest(model=" + this.getModel() + ", messages=" + this.getMessages() + ", system=" + this.getSystem() + ", maxTokens=" + this.getMaxTokens() + ", stopSequences=" + this.getStopSequences() + ", stream=" + this.isStream() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", topK=" + this.getTopK() + ", tools=" + this.getTools() + ", toolChoice=" + this.getToolChoice() + ")";
    }

    public AnthropicCreateMessageRequest() {
    }

    public AnthropicCreateMessageRequest(String model, List<AnthropicMessage> messages, String system, int maxTokens, List<String> stopSequences, boolean stream, Double temperature, Double topP, Integer topK, List<AnthropicTool> tools, AnthropicToolChoice toolChoice) {
        this.model = model;
        this.messages = messages;
        this.system = system;
        this.maxTokens = maxTokens;
        this.stopSequences = stopSequences;
        this.stream = stream;
        this.temperature = temperature;
        this.topP = topP;
        this.topK = topK;
        this.tools = tools;
        this.toolChoice = toolChoice;
    }

    public static class AnthropicCreateMessageRequestBuilder {
        private String model;
        private List<AnthropicMessage> messages;
        private String system;
        private int maxTokens;
        private List<String> stopSequences;
        private boolean stream;
        private Double temperature;
        private Double topP;
        private Integer topK;
        private List<AnthropicTool> tools;
        private AnthropicToolChoice toolChoice;

        AnthropicCreateMessageRequestBuilder() {
        }

        public AnthropicCreateMessageRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder messages(List<AnthropicMessage> messages) {
            this.messages = messages;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder system(String system) {
            this.system = system;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder maxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder tools(List<AnthropicTool> tools) {
            this.tools = tools;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder toolChoice(AnthropicToolChoice toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public AnthropicCreateMessageRequest build() {
            return new AnthropicCreateMessageRequest(this.model, this.messages, this.system, this.maxTokens, this.stopSequences, this.stream, this.temperature, this.topP, this.topK, this.tools, this.toolChoice);
        }

        public String toString() {
            return "AnthropicCreateMessageRequest.AnthropicCreateMessageRequestBuilder(model=" + this.model + ", messages=" + this.messages + ", system=" + this.system + ", maxTokens=" + this.maxTokens + ", stopSequences=" + this.stopSequences + ", stream=" + this.stream + ", temperature=" + this.temperature + ", topP=" + this.topP + ", topK=" + this.topK + ", tools=" + this.tools + ", toolChoice=" + this.toolChoice + ")";
        }
    }
}

