/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais;

import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;

public class Decoders {
    public static final Function<String, Integer> INTEGER_DECODER = new Function<String, Integer>(){

        @Override
        public Integer apply(String bitString) {
            Integer value;
            String signBit = bitString.substring(0, 1);
            String valueBits = bitString.substring(1);
            if ("0".equals(signBit)) {
                value = UNSIGNED_INTEGER_DECODER.apply(valueBits);
            } else {
                valueBits = valueBits.replaceAll("0", "x");
                valueBits = valueBits.replaceAll("1", "0");
                valueBits = valueBits.replaceAll("x", "1");
                value = UNSIGNED_INTEGER_DECODER.apply("-" + valueBits);
            }
            return value;
        }
    };
    public static final Function<String, Float> FLOAT_DECODER = bitString -> Float.valueOf(INTEGER_DECODER.apply((String)bitString).intValue());
    public static final Function<String, Boolean> BOOLEAN_DECODER = bitString -> "1".equals(bitString.substring(0, 1));
    public static final Function<String, Integer> UNSIGNED_INTEGER_DECODER = bitString -> Integer.parseInt(bitString, 2);
    public static final Function<String, Long> UNSIGNED_LONG_DECODER = bitString -> Long.parseLong(bitString, 2);
    public static final Function<String, Float> UNSIGNED_FLOAT_DECODER = bitString -> Float.valueOf(UNSIGNED_INTEGER_DECODER.apply((String)bitString).intValue());
    public static final Function<String, String> TIME_DECODER = new Function<String, String>(){

        @Override
        public String apply(String bitString) {
            Integer month = UNSIGNED_INTEGER_DECODER.apply(bitString.substring(0, 4));
            Integer day = UNSIGNED_INTEGER_DECODER.apply(bitString.substring(4, 9));
            Integer hour = UNSIGNED_INTEGER_DECODER.apply(bitString.substring(9, 14));
            Integer minute = UNSIGNED_INTEGER_DECODER.apply(bitString.substring(14, 20));
            String monthAsString = month < 10 ? "0" + month : "" + month;
            String dayAsString = day < 10 ? "0" + day : "" + day;
            String hourAsString = hour < 10 ? "0" + hour : "" + hour;
            String minuteAsString = minute < 10 ? "0" + minute : "" + minute;
            return dayAsString + "-" + monthAsString + " " + hourAsString + ":" + minuteAsString;
        }
    };
    public static final Function<String, String> STRING_DECODER = new Function<String, String>(){

        @Override
        public String apply(String bitString) {
            StringBuffer stringBuffer = new StringBuffer();
            String remainingBits = bitString;
            while (remainingBits.length() >= 6) {
                String b = remainingBits.substring(0, 6);
                remainingBits = remainingBits.substring(6);
                Integer i = UNSIGNED_INTEGER_DECODER.apply(b);
                String c = (String)SIX_BIT_ASCII.get(i);
                stringBuffer.append(c);
            }
            String string = stringBuffer.toString();
            if (STRIP_ALPHA_SIGNS.booleanValue()) {
                string = string.replaceAll("@", " ").trim();
            }
            return string;
        }
    };
    public static final Function<String, String> BIT_DECODER = bitString -> bitString;
    private static final Map<Integer, String> SIX_BIT_ASCII = new TreeMap<Integer, String>();
    private static final Boolean STRIP_ALPHA_SIGNS;

    static {
        SIX_BIT_ASCII.put(0, "@");
        SIX_BIT_ASCII.put(1, "A");
        SIX_BIT_ASCII.put(2, "B");
        SIX_BIT_ASCII.put(3, "C");
        SIX_BIT_ASCII.put(4, "D");
        SIX_BIT_ASCII.put(5, "E");
        SIX_BIT_ASCII.put(6, "F");
        SIX_BIT_ASCII.put(7, "G");
        SIX_BIT_ASCII.put(8, "H");
        SIX_BIT_ASCII.put(9, "I");
        SIX_BIT_ASCII.put(10, "J");
        SIX_BIT_ASCII.put(11, "K");
        SIX_BIT_ASCII.put(12, "L");
        SIX_BIT_ASCII.put(13, "M");
        SIX_BIT_ASCII.put(14, "N");
        SIX_BIT_ASCII.put(15, "O");
        SIX_BIT_ASCII.put(16, "P");
        SIX_BIT_ASCII.put(17, "Q");
        SIX_BIT_ASCII.put(18, "R");
        SIX_BIT_ASCII.put(19, "S");
        SIX_BIT_ASCII.put(20, "T");
        SIX_BIT_ASCII.put(21, "U");
        SIX_BIT_ASCII.put(22, "V");
        SIX_BIT_ASCII.put(23, "W");
        SIX_BIT_ASCII.put(24, "X");
        SIX_BIT_ASCII.put(25, "Y");
        SIX_BIT_ASCII.put(26, "Z");
        SIX_BIT_ASCII.put(27, "[");
        SIX_BIT_ASCII.put(28, "\\");
        SIX_BIT_ASCII.put(29, "]");
        SIX_BIT_ASCII.put(30, "^");
        SIX_BIT_ASCII.put(31, "_");
        SIX_BIT_ASCII.put(32, " ");
        SIX_BIT_ASCII.put(33, "!");
        SIX_BIT_ASCII.put(34, "\"");
        SIX_BIT_ASCII.put(35, "#");
        SIX_BIT_ASCII.put(36, "$");
        SIX_BIT_ASCII.put(37, "%");
        SIX_BIT_ASCII.put(38, "&");
        SIX_BIT_ASCII.put(39, "'");
        SIX_BIT_ASCII.put(40, "(");
        SIX_BIT_ASCII.put(41, ")");
        SIX_BIT_ASCII.put(42, "*");
        SIX_BIT_ASCII.put(43, "+");
        SIX_BIT_ASCII.put(44, ",");
        SIX_BIT_ASCII.put(45, "-");
        SIX_BIT_ASCII.put(46, ".");
        SIX_BIT_ASCII.put(47, "/");
        SIX_BIT_ASCII.put(48, "0");
        SIX_BIT_ASCII.put(49, "1");
        SIX_BIT_ASCII.put(50, "2");
        SIX_BIT_ASCII.put(51, "3");
        SIX_BIT_ASCII.put(52, "4");
        SIX_BIT_ASCII.put(53, "5");
        SIX_BIT_ASCII.put(54, "6");
        SIX_BIT_ASCII.put(55, "7");
        SIX_BIT_ASCII.put(56, "8");
        SIX_BIT_ASCII.put(57, "9");
        SIX_BIT_ASCII.put(58, ":");
        SIX_BIT_ASCII.put(59, ";");
        SIX_BIT_ASCII.put(60, "<");
        SIX_BIT_ASCII.put(61, "=");
        SIX_BIT_ASCII.put(62, ">");
        SIX_BIT_ASCII.put(63, "?");
        STRIP_ALPHA_SIGNS = true;
    }
}

