/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.exceptions.UnsupportedMessageType;
import dk.tbsalling.aismessages.ais.messages.AddressedBinaryMessage;
import dk.tbsalling.aismessages.ais.messages.AddressedSafetyRelatedMessage;
import dk.tbsalling.aismessages.ais.messages.AidToNavigationReport;
import dk.tbsalling.aismessages.ais.messages.AssignedModeCommand;
import dk.tbsalling.aismessages.ais.messages.BaseStationReport;
import dk.tbsalling.aismessages.ais.messages.BinaryAcknowledge;
import dk.tbsalling.aismessages.ais.messages.BinaryBroadcastMessage;
import dk.tbsalling.aismessages.ais.messages.BinaryMessageMultipleSlot;
import dk.tbsalling.aismessages.ais.messages.BinaryMessageSingleSlot;
import dk.tbsalling.aismessages.ais.messages.CachedDecodedValues;
import dk.tbsalling.aismessages.ais.messages.ChannelManagement;
import dk.tbsalling.aismessages.ais.messages.ClassBCSStaticDataReport;
import dk.tbsalling.aismessages.ais.messages.DataLinkManagement;
import dk.tbsalling.aismessages.ais.messages.ExtendedClassBEquipmentPositionReport;
import dk.tbsalling.aismessages.ais.messages.GNSSBinaryBroadcastMessage;
import dk.tbsalling.aismessages.ais.messages.GroupAssignmentCommand;
import dk.tbsalling.aismessages.ais.messages.Interrogation;
import dk.tbsalling.aismessages.ais.messages.LongRangeBroadcastMessage;
import dk.tbsalling.aismessages.ais.messages.Metadata;
import dk.tbsalling.aismessages.ais.messages.PositionReportClassAAssignedSchedule;
import dk.tbsalling.aismessages.ais.messages.PositionReportClassAResponseToInterrogation;
import dk.tbsalling.aismessages.ais.messages.PositionReportClassAScheduled;
import dk.tbsalling.aismessages.ais.messages.SafetyRelatedAcknowledge;
import dk.tbsalling.aismessages.ais.messages.SafetyRelatedBroadcastMessage;
import dk.tbsalling.aismessages.ais.messages.ShipAndVoyageData;
import dk.tbsalling.aismessages.ais.messages.StandardClassBCSPositionReport;
import dk.tbsalling.aismessages.ais.messages.StandardSARAircraftPositionReport;
import dk.tbsalling.aismessages.ais.messages.UTCAndDateInquiry;
import dk.tbsalling.aismessages.ais.messages.UTCAndDateResponse;
import dk.tbsalling.aismessages.ais.messages.types.AISMessageType;
import dk.tbsalling.aismessages.ais.messages.types.MMSI;
import dk.tbsalling.aismessages.nmea.exceptions.InvalidMessage;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.logging.Logger;

public abstract class AISMessage
implements Serializable,
CachedDecodedValues {
    private static final transient Logger LOG = Logger.getLogger(AISMessage.class.getName());
    public static final transient String VERSION = "2.1.1";
    private NMEAMessage[] nmeaMessages;
    private Metadata metadata;
    private transient WeakReference<String> bitString = new WeakReference<Object>(null);
    private transient int numberOfBits = -1;
    private transient Integer repeatIndicator;
    private transient MMSI sourceMmsi;
    private static final Map<String, String> charToSixBit;

    protected AISMessage() {
    }

    protected AISMessage(NMEAMessage[] nmeaMessages) {
        Objects.requireNonNull(nmeaMessages);
        AISMessage.check(nmeaMessages);
        this.nmeaMessages = nmeaMessages;
        AISMessageType nmeaMessageType = this.decodeMessageType();
        if (this.getMessageType() != nmeaMessageType) {
            throw new UnsupportedMessageType(nmeaMessageType.getCode());
        }
        if (!this.isValid()) {
            throw new InvalidMessage("Invalid AIS message");
        }
        this.checkAISMessage();
    }

    protected AISMessage(NMEAMessage[] nmeaMessages, String bitString) {
        Objects.requireNonNull(nmeaMessages);
        AISMessage.check(nmeaMessages);
        this.nmeaMessages = nmeaMessages;
        this.bitString = new WeakReference<String>(bitString);
        AISMessageType nmeaMessageType = this.decodeMessageType();
        if (this.getMessageType() != nmeaMessageType) {
            throw new UnsupportedMessageType(nmeaMessageType.getCode());
        }
        if (!this.isValid()) {
            StringBuffer sb = new StringBuffer();
            for (NMEAMessage nmeaMessage : nmeaMessages) {
                sb.append(nmeaMessage);
            }
            throw new InvalidMessage("Invalid AIS message: " + sb.toString());
        }
        this.checkAISMessage();
    }

    private static void check(NMEAMessage[] nmeaMessages) {
    }

    public byte[] digest() throws NoSuchAlgorithmException {
        MessageDigest messageDigester = MessageDigest.getInstance("SHA");
        for (NMEAMessage nmeaMessage : this.nmeaMessages) {
            messageDigester.update(nmeaMessage.getRawMessage().getBytes());
        }
        return messageDigester.digest();
    }

    public Map<String, Object> dataFields() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors()) {
                Object value;
                if ("class".equals(propertyDescriptor.getName())) continue;
                Method readMethod = propertyDescriptor.getReadMethod();
                Class<?> returnType = readMethod.getReturnType();
                if (this.isComplexType(returnType)) {
                    PropertyDescriptor[] propertyDescriptors2;
                    Object complexValue = readMethod.invoke((Object)this, new Object[0]);
                    if (complexValue == null) continue;
                    for (PropertyDescriptor pd2 : propertyDescriptors2 = Introspector.getBeanInfo(returnType).getPropertyDescriptors()) {
                        if ("class".equals(pd2.getName())) continue;
                        map.put(propertyDescriptor.getName() + "." + pd2.getName(), pd2.getReadMethod().invoke(complexValue, new Object[0]));
                    }
                    continue;
                }
                if (Class.class.equals(returnType)) {
                    value = readMethod.invoke((Object)this, new Object[0]);
                    map.put(propertyDescriptor.getName(), ((Class)value).getSimpleName());
                    continue;
                }
                value = readMethod.invoke((Object)this, new Object[0]);
                if (value == null) continue;
                if (returnType.isEnum()) {
                    map.put(propertyDescriptor.getName(), value.toString());
                    continue;
                }
                map.put(propertyDescriptor.getName(), value);
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return map;
    }

    private boolean isComplexType(Class<?> clazz) {
        if (clazz.isArray() || clazz.isEnum() || clazz.getPackage() == null || !"dk.tbsalling.aismessages.ais.messages.types".equals(clazz.getPackage().getName())) {
            return false;
        }
        boolean hasGetters = false;
        try {
            hasGetters = Introspector.getBeanInfo(clazz).getPropertyDescriptors().length > 0;
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        return hasGetters;
    }

    protected abstract void checkAISMessage();

    public NMEAMessage[] getNmeaMessages() {
        return this.nmeaMessages;
    }

    public abstract AISMessageType getMessageType();

    public final Metadata getMetadata() {
        return this.metadata;
    }

    public final void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    private AISMessageType decodeMessageType() {
        return AISMessageType.fromInteger(Integer.parseInt(this.getBits(0, 6), 2));
    }

    public final Integer getRepeatIndicator() {
        return this.getDecodedValue(() -> this.repeatIndicator, value -> {
            this.repeatIndicator = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(6, 8)));
    }

    public final MMSI getSourceMmsi() {
        return this.getDecodedValue(() -> this.sourceMmsi, value -> {
            this.sourceMmsi = value;
        }, () -> Boolean.TRUE, () -> MMSI.valueOf(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(8, 38))));
    }

    public String toString() {
        return "AISMessage{nmeaMessages=" + Arrays.toString(this.nmeaMessages) + ", metadata=" + this.metadata + ", repeatIndicator=" + this.getRepeatIndicator() + ", sourceMmsi=" + this.getSourceMmsi() + '}';
    }

    protected String getBitString() {
        String b = (String)this.bitString.get();
        if (b == null) {
            b = AISMessage.decodePayloadToBitString(this.nmeaMessages);
            this.bitString = new WeakReference<String>(b);
        }
        return b;
    }

    protected String getZeroBitStuffedString(Integer endIndex) {
        String b = this.getBitString();
        if (b.length() - endIndex < 0) {
            StringBuffer c = new StringBuffer(b);
            for (int i = b.length() - endIndex; i < 0; ++i) {
                c = c.append("0");
            }
            b = c.toString();
        }
        return b;
    }

    protected String getBits(Integer beginIndex, Integer endIndex) {
        return this.getZeroBitStuffedString(endIndex).substring(beginIndex, endIndex);
    }

    protected int getNumberOfBits() {
        if (this.numberOfBits < 0) {
            this.numberOfBits = this.getBitString().length();
        }
        return this.numberOfBits;
    }

    protected static String decodePayloadToBitString(NMEAMessage ... nmeaMessages) {
        StringBuilder sixBitEncodedPayload = new StringBuilder();
        int fillBits = -1;
        for (int i = 0; i < nmeaMessages.length; ++i) {
            NMEAMessage m = nmeaMessages[i];
            sixBitEncodedPayload.append(m.getEncodedPayload());
            if (i != nmeaMessages.length - 1) continue;
            fillBits = m.getFillBits();
        }
        return AISMessage.toBitString(sixBitEncodedPayload.toString(), fillBits);
    }

    public static AISMessage create(Metadata metadata, NMEAMessage ... nmeaMessages) {
        AISMessage aisMessage = AISMessage.create(nmeaMessages);
        aisMessage.setMetadata(metadata);
        return aisMessage;
    }

    public static AISMessage create(NMEAMessage ... nmeaMessages) {
        BiFunction<NMEAMessage[], String, AISMessage> aisMessageConstructor;
        String bitString;
        block31: {
            block30: {
                bitString = AISMessage.decodePayloadToBitString(nmeaMessages);
                AISMessageType messageType = AISMessageType.fromInteger(Integer.parseInt(bitString.substring(0, 6), 2));
                if (messageType == null) break block30;
                switch (messageType) {
                    case ShipAndVoyageRelatedData: {
                        aisMessageConstructor = ShipAndVoyageData::new;
                        break block31;
                    }
                    case PositionReportClassAScheduled: {
                        aisMessageConstructor = PositionReportClassAScheduled::new;
                        break block31;
                    }
                    case PositionReportClassAAssignedSchedule: {
                        aisMessageConstructor = PositionReportClassAAssignedSchedule::new;
                        break block31;
                    }
                    case PositionReportClassAResponseToInterrogation: {
                        aisMessageConstructor = PositionReportClassAResponseToInterrogation::new;
                        break block31;
                    }
                    case BaseStationReport: {
                        aisMessageConstructor = BaseStationReport::new;
                        break block31;
                    }
                    case AddressedBinaryMessage: {
                        aisMessageConstructor = AddressedBinaryMessage::new;
                        break block31;
                    }
                    case BinaryAcknowledge: {
                        aisMessageConstructor = BinaryAcknowledge::new;
                        break block31;
                    }
                    case BinaryBroadcastMessage: {
                        aisMessageConstructor = BinaryBroadcastMessage::new;
                        break block31;
                    }
                    case StandardSARAircraftPositionReport: {
                        aisMessageConstructor = StandardSARAircraftPositionReport::new;
                        break block31;
                    }
                    case UTCAndDateInquiry: {
                        aisMessageConstructor = UTCAndDateInquiry::new;
                        break block31;
                    }
                    case UTCAndDateResponse: {
                        aisMessageConstructor = UTCAndDateResponse::new;
                        break block31;
                    }
                    case AddressedSafetyRelatedMessage: {
                        aisMessageConstructor = AddressedSafetyRelatedMessage::new;
                        break block31;
                    }
                    case SafetyRelatedAcknowledge: {
                        aisMessageConstructor = SafetyRelatedAcknowledge::new;
                        break block31;
                    }
                    case SafetyRelatedBroadcastMessage: {
                        aisMessageConstructor = SafetyRelatedBroadcastMessage::new;
                        break block31;
                    }
                    case Interrogation: {
                        aisMessageConstructor = Interrogation::new;
                        break block31;
                    }
                    case AssignedModeCommand: {
                        aisMessageConstructor = AssignedModeCommand::new;
                        break block31;
                    }
                    case GNSSBinaryBroadcastMessage: {
                        aisMessageConstructor = GNSSBinaryBroadcastMessage::new;
                        break block31;
                    }
                    case StandardClassBCSPositionReport: {
                        aisMessageConstructor = StandardClassBCSPositionReport::new;
                        break block31;
                    }
                    case ExtendedClassBEquipmentPositionReport: {
                        aisMessageConstructor = ExtendedClassBEquipmentPositionReport::new;
                        break block31;
                    }
                    case DataLinkManagement: {
                        aisMessageConstructor = DataLinkManagement::new;
                        break block31;
                    }
                    case AidToNavigationReport: {
                        aisMessageConstructor = AidToNavigationReport::new;
                        break block31;
                    }
                    case ChannelManagement: {
                        aisMessageConstructor = ChannelManagement::new;
                        break block31;
                    }
                    case GroupAssignmentCommand: {
                        aisMessageConstructor = GroupAssignmentCommand::new;
                        break block31;
                    }
                    case ClassBCSStaticDataReport: {
                        aisMessageConstructor = ClassBCSStaticDataReport::new;
                        break block31;
                    }
                    case BinaryMessageSingleSlot: {
                        aisMessageConstructor = BinaryMessageSingleSlot::new;
                        break block31;
                    }
                    case BinaryMessageMultipleSlot: {
                        aisMessageConstructor = BinaryMessageMultipleSlot::new;
                        break block31;
                    }
                    case LongRangeBroadcastMessage: {
                        aisMessageConstructor = LongRangeBroadcastMessage::new;
                        break block31;
                    }
                    default: {
                        throw new UnsupportedMessageType(messageType.getCode());
                    }
                }
            }
            StringBuffer sb = new StringBuffer();
            for (NMEAMessage nmeaMessage : nmeaMessages) {
                sb.append(nmeaMessage);
            }
            throw new InvalidMessage("Cannot extract message type from NMEA message: " + sb.toString());
        }
        return aisMessageConstructor.apply(nmeaMessages, bitString);
    }

    public boolean isValid() {
        String bitString = this.getBitString();
        if (bitString.length() < 6) {
            LOG.warning("Message is too short: " + bitString.length() + " bits.");
            return Boolean.FALSE;
        }
        int messageType = Integer.parseInt(bitString.substring(0, 6), 2);
        if (messageType < 1 || messageType > 27) {
            LOG.warning("Unsupported message type: " + messageType);
            return Boolean.FALSE;
        }
        int actualMessageLength = bitString.length();
        switch (messageType) {
            case 1: {
                if (actualMessageLength == 168) break;
                LOG.warning("Message type 1: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 2: {
                if (actualMessageLength == 168) break;
                LOG.warning("Message type 2: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 3: {
                if (actualMessageLength == 168) break;
                LOG.warning("Message type 3: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 4: {
                if (actualMessageLength == 168) break;
                return Boolean.FALSE;
            }
            case 5: {
                if (actualMessageLength == 424 || actualMessageLength == 422) break;
                LOG.warning("Message type 5: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 6: {
                if (actualMessageLength <= 1008) break;
                LOG.warning("Message type 6: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 7: {
                if (actualMessageLength == 72 || actualMessageLength == 104 || actualMessageLength == 136 || actualMessageLength == 168) break;
                LOG.warning("Message type 7: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 8: {
                if (actualMessageLength <= 1008) break;
                LOG.warning("Message type 8: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 9: {
                if (actualMessageLength == 168) break;
                LOG.warning("Message type 9: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 10: {
                if (actualMessageLength == 72) break;
                LOG.warning("Message type 10: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 11: {
                if (actualMessageLength == 168) break;
                return Boolean.FALSE;
            }
            case 12: {
                if (actualMessageLength <= 1008) break;
                LOG.warning("Message type 12: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 13: {
                if (actualMessageLength == 72 || actualMessageLength == 104 || actualMessageLength == 136 || actualMessageLength == 168) break;
                LOG.warning("Message type 13: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 14: {
                if (actualMessageLength <= 1008) break;
                LOG.warning("Message type 14: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 15: {
                if (actualMessageLength == 88 || actualMessageLength == 110 || actualMessageLength == 112 || actualMessageLength == 160) break;
                return Boolean.FALSE;
            }
            case 16: {
                if (actualMessageLength == 96 || actualMessageLength == 144) break;
                LOG.warning("Message type 16: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 17: {
                if (actualMessageLength >= 80 && actualMessageLength <= 816) break;
                LOG.warning("Message type 17: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 18: {
                if (actualMessageLength == 168) break;
                LOG.warning("Message type 18: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 19: {
                if (actualMessageLength == 312) break;
                LOG.warning("Message type 19: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 20: {
                if (actualMessageLength >= 72 && actualMessageLength <= 160) break;
                LOG.warning("Message type 20: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 21: {
                if (actualMessageLength >= 272 && actualMessageLength <= 360) break;
                LOG.warning("Message type 21: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 22: {
                if (actualMessageLength == 168) break;
                LOG.warning("Message type 22: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 23: {
                if (actualMessageLength == 160) break;
                LOG.warning("Message type 23: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 24: {
                if (actualMessageLength == 160 || actualMessageLength == 168 || actualMessageLength == 158) break;
                LOG.warning("Message type 24: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 25: {
                if (actualMessageLength <= 168) break;
                LOG.warning("Message type 25: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            case 26: {
                break;
            }
            case 27: {
                if (actualMessageLength == 96 || actualMessageLength == 168) break;
                LOG.warning("Message type 27: Illegal message length: " + bitString.length() + " bits.");
                return Boolean.FALSE;
            }
            default: {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private static String toBitString(String encodedString, Integer paddingBits) {
        StringBuilder bitString = new StringBuilder();
        int n = encodedString.length();
        for (int i = 0; i < n; ++i) {
            String c = encodedString.substring(i, i + 1);
            bitString.append(charToSixBit.get(c));
        }
        return bitString.substring(0, bitString.length() - paddingBits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AISMessage)) {
            return false;
        }
        AISMessage that = (AISMessage)o;
        if (!this.getBitString().equals(that.getBitString())) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        int result = this.metadata != null ? this.metadata.hashCode() : 0;
        result = 31 * result + this.getBitString().hashCode();
        return result;
    }

    static {
        System.err.print("\nAISMessages v2.1.1 // Copyright (c) 2011- by S-Consult ApS, Denmark, CVR DK31327490. http://s-consult.dk.\n\nThis work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License. To view a copy of\nthis license, visit http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 171 Second Street,\nSuite 300, San Francisco, California, 94105, USA.\n\nNOT FOR COMMERCIAL USE!\nContact sales@s-consult.dk to obtain commercially licensed software.\n\n");
        charToSixBit = new TreeMap<String, String>();
        charToSixBit.put("0", "000000");
        charToSixBit.put("1", "000001");
        charToSixBit.put("2", "000010");
        charToSixBit.put("3", "000011");
        charToSixBit.put("4", "000100");
        charToSixBit.put("5", "000101");
        charToSixBit.put("6", "000110");
        charToSixBit.put("7", "000111");
        charToSixBit.put("8", "001000");
        charToSixBit.put("9", "001001");
        charToSixBit.put(":", "001010");
        charToSixBit.put(";", "001011");
        charToSixBit.put("<", "001100");
        charToSixBit.put("=", "001101");
        charToSixBit.put(">", "001110");
        charToSixBit.put("?", "001111");
        charToSixBit.put("@", "010000");
        charToSixBit.put("A", "010001");
        charToSixBit.put("B", "010010");
        charToSixBit.put("C", "010011");
        charToSixBit.put("D", "010100");
        charToSixBit.put("E", "010101");
        charToSixBit.put("F", "010110");
        charToSixBit.put("G", "010111");
        charToSixBit.put("H", "011000");
        charToSixBit.put("I", "011001");
        charToSixBit.put("J", "011010");
        charToSixBit.put("K", "011011");
        charToSixBit.put("L", "011100");
        charToSixBit.put("M", "011101");
        charToSixBit.put("N", "011110");
        charToSixBit.put("O", "011111");
        charToSixBit.put("P", "100000");
        charToSixBit.put("Q", "100001");
        charToSixBit.put("R", "100010");
        charToSixBit.put("S", "100011");
        charToSixBit.put("T", "100100");
        charToSixBit.put("U", "100101");
        charToSixBit.put("V", "100110");
        charToSixBit.put("W", "100111");
        charToSixBit.put("`", "101000");
        charToSixBit.put("a", "101001");
        charToSixBit.put("b", "101010");
        charToSixBit.put("c", "101011");
        charToSixBit.put("d", "101100");
        charToSixBit.put("e", "101101");
        charToSixBit.put("f", "101110");
        charToSixBit.put("g", "101111");
        charToSixBit.put("h", "110000");
        charToSixBit.put("i", "110001");
        charToSixBit.put("j", "110010");
        charToSixBit.put("k", "110011");
        charToSixBit.put("l", "110100");
        charToSixBit.put("m", "110101");
        charToSixBit.put("n", "110110");
        charToSixBit.put("o", "110111");
        charToSixBit.put("p", "111000");
        charToSixBit.put("q", "111001");
        charToSixBit.put("r", "111010");
        charToSixBit.put("s", "111011");
        charToSixBit.put("t", "111100");
        charToSixBit.put("u", "111101");
        charToSixBit.put("v", "111110");
        charToSixBit.put("w", "111111");
    }
}

