/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.messages.AISMessage;
import dk.tbsalling.aismessages.ais.messages.types.AISMessageType;
import dk.tbsalling.aismessages.ais.messages.types.MMSI;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;

public class AddressedSafetyRelatedMessage
extends AISMessage {
    private transient Integer sequenceNumber;
    private transient MMSI destinationMmsi;
    private transient Boolean retransmit;
    private transient Integer spare;
    private transient String text;

    public AddressedSafetyRelatedMessage(NMEAMessage[] nmeaMessages) {
        super(nmeaMessages);
    }

    protected AddressedSafetyRelatedMessage(NMEAMessage[] nmeaMessages, String bitString) {
        super(nmeaMessages, bitString);
    }

    @Override
    protected void checkAISMessage() {
    }

    @Override
    public AISMessageType getMessageType() {
        return AISMessageType.AddressedSafetyRelatedMessage;
    }

    public Integer getSequenceNumber() {
        return this.getDecodedValue(() -> this.sequenceNumber, value -> {
            this.sequenceNumber = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(38, 40)));
    }

    public MMSI getDestinationMmsi() {
        return this.getDecodedValue(() -> this.destinationMmsi, value -> {
            this.destinationMmsi = value;
        }, () -> Boolean.TRUE, () -> MMSI.valueOf(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(40, 70))));
    }

    public Boolean getRetransmit() {
        return this.getDecodedValue(() -> this.retransmit, value -> {
            this.retransmit = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(70, 71)));
    }

    public Integer getSpare() {
        return this.getDecodedValue(() -> this.spare, value -> {
            this.spare = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(71, 72)));
    }

    public String getText() {
        return this.getDecodedValue(() -> this.text, value -> {
            this.text = value;
        }, () -> Boolean.TRUE, () -> {
            int extraBitsOfChars = (this.getNumberOfBits() - 72) / 6 * 6;
            return Decoders.STRING_DECODER.apply(this.getBits(72, 72 + extraBitsOfChars));
        });
    }

    @Override
    public String toString() {
        return "AddressedSafetyRelatedMessage{messageType=" + (Object)((Object)this.getMessageType()) + ", sequenceNumber=" + this.getSequenceNumber() + ", destinationMmsi=" + this.getDestinationMmsi() + ", retransmit=" + this.getRetransmit() + ", spare=" + this.getSpare() + ", text='" + this.getText() + '\'' + "} " + super.toString();
    }
}

