/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.messages.AISMessage;
import dk.tbsalling.aismessages.ais.messages.types.AISMessageType;
import dk.tbsalling.aismessages.ais.messages.types.AidType;
import dk.tbsalling.aismessages.ais.messages.types.PositionFixingDevice;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;

public class AidToNavigationReport
extends AISMessage {
    private transient AidType aidType;
    private transient String name;
    private transient Boolean positionAccurate;
    private transient Float latitude;
    private transient Float longitude;
    private transient Integer toBow;
    private transient Integer toStern;
    private transient Integer toPort;
    private transient Integer toStarboard;
    private transient PositionFixingDevice positionFixingDevice;
    private transient Integer second;
    private transient Boolean offPosition;
    private transient String regionalUse;
    private transient Boolean raimFlag;
    private transient Boolean virtualAid;
    private transient Boolean assignedMode;
    private transient Integer spare1;
    private transient String nameExtension;
    private transient Integer spare2;

    public AidToNavigationReport(NMEAMessage[] nmeaMessages) {
        super(nmeaMessages);
    }

    protected AidToNavigationReport(NMEAMessage[] nmeaMessages, String bitString) {
        super(nmeaMessages, bitString);
    }

    @Override
    protected void checkAISMessage() {
    }

    @Override
    public final AISMessageType getMessageType() {
        return AISMessageType.AidToNavigationReport;
    }

    public AidType getAidType() {
        return this.getDecodedValue(() -> this.aidType, value -> {
            this.aidType = value;
        }, () -> Boolean.TRUE, () -> AidType.fromInteger(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(38, 43))));
    }

    public String getName() {
        return this.getDecodedValue(() -> this.name, value -> {
            this.name = value;
        }, () -> Boolean.TRUE, () -> Decoders.STRING_DECODER.apply(this.getBits(43, 163)));
    }

    public Boolean getPositionAccurate() {
        return this.getDecodedValue(() -> this.positionAccurate, value -> {
            this.positionAccurate = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(163, 164)));
    }

    public Float getLatitude() {
        return this.getDecodedValue(() -> this.latitude, value -> {
            this.latitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(192, 219)).floatValue() / 600000.0f));
    }

    public Float getLongitude() {
        return this.getDecodedValue(() -> this.longitude, value -> {
            this.longitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(164, 192)).floatValue() / 600000.0f));
    }

    public Integer getToBow() {
        return this.getDecodedValue(() -> this.toBow, value -> {
            this.toBow = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(219, 228)));
    }

    public Integer getToStern() {
        return this.getDecodedValue(() -> this.toStern, value -> {
            this.toStern = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(228, 237)));
    }

    public Integer getToStarboard() {
        return this.getDecodedValue(() -> this.toStarboard, value -> {
            this.toStarboard = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(243, 249)));
    }

    public Integer getToPort() {
        return this.getDecodedValue(() -> this.toPort, value -> {
            this.toPort = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(237, 243)));
    }

    public PositionFixingDevice getPositionFixingDevice() {
        return this.getDecodedValue(() -> this.positionFixingDevice, value -> {
            this.positionFixingDevice = value;
        }, () -> Boolean.TRUE, () -> PositionFixingDevice.fromInteger(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(249, 253))));
    }

    public Integer getSecond() {
        return this.getDecodedValue(() -> this.second, value -> {
            this.second = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(253, 259)));
    }

    public Boolean getOffPosition() {
        return this.getDecodedValue(() -> this.offPosition, value -> {
            this.offPosition = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(259, 260)));
    }

    public String getAtoNStatus() {
        return this.getDecodedValue(() -> this.regionalUse, value -> {
            this.regionalUse = value;
        }, () -> Boolean.TRUE, () -> Decoders.BIT_DECODER.apply(this.getBits(260, 268)));
    }

    public Boolean getRaimFlag() {
        return this.getDecodedValue(() -> this.raimFlag, value -> {
            this.raimFlag = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(268, 269)));
    }

    public Boolean getVirtualAid() {
        return this.getDecodedValue(() -> this.virtualAid, value -> {
            this.virtualAid = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(269, 270)));
    }

    public Boolean getAssignedMode() {
        return this.getDecodedValue(() -> this.assignedMode, value -> {
            this.assignedMode = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(270, 271)));
    }

    public Integer getSpare1() {
        return this.getDecodedValue(() -> this.spare1, value -> {
            this.spare1 = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(271, 272)));
    }

    public String getNameExtension() {
        this.getDecodedValue(() -> this.nameExtension, value -> {
            this.nameExtension = value;
        }, () -> this.getNumberOfBits() > 272, () -> {
            int extraBits = this.getNumberOfBits() - 272;
            int extraChars = extraBits / 6;
            int extraBitsOfChars = extraChars * 6;
            return Decoders.STRING_DECODER.apply(this.getBits(272, 272 + extraBitsOfChars));
        });
        return this.nameExtension;
    }

    public Integer getSpare2() {
        this.getDecodedValue(() -> this.spare2, value -> {
            this.spare2 = value;
        }, () -> this.getNumberOfBits() >= 272, () -> {
            int extraChars;
            int extraBitsOfChars;
            int extraBits = this.getNumberOfBits() - 272;
            return extraBits == (extraBitsOfChars = (extraChars = extraBits / 6) * 6) ? Integer.valueOf(0) : Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(272 + extraBitsOfChars, this.getNumberOfBits()));
        });
        return this.spare2;
    }

    @Override
    public String toString() {
        return "AidToNavigationReport{messageType=" + (Object)((Object)this.getMessageType()) + ", aidType=" + (Object)((Object)this.getAidType()) + ", name='" + this.getName() + '\'' + ", positionAccurate=" + this.getPositionAccurate() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", toBow=" + this.getToBow() + ", toStern=" + this.getToStern() + ", toPort=" + this.getToPort() + ", toStarboard=" + this.getToStarboard() + ", positionFixingDevice=" + (Object)((Object)this.getPositionFixingDevice()) + ", second=" + this.getSecond() + ", offPosition=" + this.getOffPosition() + ", regionalUse='" + this.getAtoNStatus() + '\'' + ", raimFlag=" + this.getRaimFlag() + ", virtualAid=" + this.getVirtualAid() + ", assignedMode=" + this.getAssignedMode() + ", spare1=" + this.getSpare1() + ", nameExtension='" + this.getNameExtension() + '\'' + ", spare2=" + this.getSpare2() + "} " + super.toString();
    }
}

