/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.messages.AISMessage;
import dk.tbsalling.aismessages.ais.messages.types.AISMessageType;
import dk.tbsalling.aismessages.ais.messages.types.MMSI;
import dk.tbsalling.aismessages.ais.messages.types.TxRxMode;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;

public class ChannelManagement
extends AISMessage {
    private transient Integer channelA;
    private transient Integer channelB;
    private transient TxRxMode transmitReceiveMode;
    private transient Boolean power;
    private transient Float northEastLongitude;
    private transient Float northEastLatitude;
    private transient Float southWestLongitude;
    private transient Float southWestLatitude;
    private transient MMSI destinationMmsi1;
    private transient MMSI destinationMmsi2;
    private transient Boolean addressed;
    private transient Boolean bandA;
    private transient Boolean bandB;
    private transient Integer zoneSize;

    public ChannelManagement(NMEAMessage[] nmeaMessages) {
        super(nmeaMessages);
    }

    protected ChannelManagement(NMEAMessage[] nmeaMessages, String bitString) {
        super(nmeaMessages, bitString);
    }

    @Override
    protected void checkAISMessage() {
    }

    @Override
    public final AISMessageType getMessageType() {
        return AISMessageType.ChannelManagement;
    }

    public Integer getChannelA() {
        return this.getDecodedValue(() -> this.channelA, value -> {
            this.channelA = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(40, 52)));
    }

    public Integer getChannelB() {
        return this.getDecodedValue(() -> this.channelB, value -> {
            this.channelB = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(52, 64)));
    }

    public TxRxMode getTransmitReceiveMode() {
        return this.getDecodedValue(() -> this.transmitReceiveMode, value -> {
            this.transmitReceiveMode = value;
        }, () -> Boolean.TRUE, () -> TxRxMode.fromInteger(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(64, 68))));
    }

    public Boolean getPower() {
        return this.getDecodedValue(() -> this.power, value -> {
            this.power = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(68, 69)));
    }

    public Float getNorthEastLongitude() {
        return this.getDecodedValue(() -> this.northEastLongitude, value -> {
            this.northEastLongitude = value;
        }, () -> this.getAddressed() == false, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(69, 87)).floatValue() / 10.0f));
    }

    public Float getNorthEastLatitude() {
        return this.getDecodedValue(() -> this.northEastLatitude, value -> {
            this.northEastLatitude = value;
        }, () -> this.getAddressed() == false, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(87, 104)).floatValue() / 10.0f));
    }

    public Float getSouthWestLongitude() {
        return this.getDecodedValue(() -> this.southWestLongitude, value -> {
            this.southWestLongitude = value;
        }, () -> this.getAddressed() == false, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(104, 122)).floatValue() / 10.0f));
    }

    public Float getSouthWestLatitude() {
        return this.getDecodedValue(() -> this.southWestLatitude, value -> {
            this.southWestLatitude = value;
        }, () -> this.getAddressed() == false, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(122, 138)).floatValue() / 10.0f));
    }

    public MMSI getDestinationMmsi1() {
        return this.getDecodedValue(() -> this.destinationMmsi1, value -> {
            this.destinationMmsi1 = value;
        }, () -> this.getAddressed(), () -> MMSI.valueOf(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(69, 99))));
    }

    public MMSI getDestinationMmsi2() {
        return this.getDecodedValue(() -> this.destinationMmsi2, value -> {
            this.destinationMmsi2 = value;
        }, () -> this.getAddressed(), () -> MMSI.valueOf(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(104, 134))));
    }

    public Boolean getAddressed() {
        return this.getDecodedValue(() -> this.addressed, value -> {
            this.addressed = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(139, 140)));
    }

    public Boolean getBandA() {
        return this.getDecodedValue(() -> this.bandA, value -> {
            this.bandA = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(140, 141)));
    }

    public Boolean getBandB() {
        return this.getDecodedValue(() -> this.bandB, value -> {
            this.bandB = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(141, 142)));
    }

    public Integer getZoneSize() {
        return this.getDecodedValue(() -> this.zoneSize, value -> {
            this.zoneSize = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(142, 145)));
    }

    @Override
    public String toString() {
        return "ChannelManagement{messageType=" + (Object)((Object)this.getMessageType()) + ", channelA=" + this.getChannelA() + ", channelB=" + this.getChannelB() + ", transmitReceiveMode=" + (Object)((Object)this.getTransmitReceiveMode()) + ", power=" + this.getPower() + ", northEastLongitude=" + this.getNorthEastLongitude() + ", northEastLatitude=" + this.getNorthEastLatitude() + ", southWestLongitude=" + this.getSouthWestLongitude() + ", southWestLatitude=" + this.getSouthWestLatitude() + ", destinationMmsi1=" + this.getDestinationMmsi1() + ", destinationMmsi2=" + this.getDestinationMmsi2() + ", addressed=" + this.getAddressed() + ", bandA=" + this.getBandA() + ", bandB=" + this.getBandB() + ", zoneSize=" + this.getZoneSize() + "} " + super.toString();
    }
}

