/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.messages.AISMessage;
import dk.tbsalling.aismessages.ais.messages.ExtendedDynamicDataReport;
import dk.tbsalling.aismessages.ais.messages.types.AISMessageType;
import dk.tbsalling.aismessages.ais.messages.types.PositionFixingDevice;
import dk.tbsalling.aismessages.ais.messages.types.ShipType;
import dk.tbsalling.aismessages.ais.messages.types.TransponderClass;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;

public class ExtendedClassBEquipmentPositionReport
extends AISMessage
implements ExtendedDynamicDataReport {
    private transient String regionalReserved1;
    private transient Float speedOverGround;
    private transient Boolean positionAccurate;
    private transient Float latitude;
    private transient Float longitude;
    private transient Float courseOverGround;
    private transient Integer trueHeading;
    private transient Integer second;
    private transient String regionalReserved2;
    private transient String shipName;
    private transient ShipType shipType;
    private transient Integer toBow;
    private transient Integer toStern;
    private transient Integer toStarboard;
    private transient Integer toPort;
    private transient PositionFixingDevice positionFixingDevice;
    private transient Boolean raimFlag;
    private transient Boolean dataTerminalReady;
    private transient Boolean assigned;

    public ExtendedClassBEquipmentPositionReport(NMEAMessage[] nmeaMessages) {
        super(nmeaMessages);
    }

    protected ExtendedClassBEquipmentPositionReport(NMEAMessage[] nmeaMessages, String bitString) {
        super(nmeaMessages, bitString);
    }

    @Override
    protected void checkAISMessage() {
    }

    @Override
    public final AISMessageType getMessageType() {
        return AISMessageType.ExtendedClassBEquipmentPositionReport;
    }

    @Override
    public TransponderClass getTransponderClass() {
        return TransponderClass.B;
    }

    public String getRegionalReserved1() {
        return this.getDecodedValue(() -> this.regionalReserved1, value -> {
            this.regionalReserved1 = value;
        }, () -> Boolean.TRUE, () -> Decoders.BIT_DECODER.apply(this.getBits(38, 46)));
    }

    @Override
    public Float getSpeedOverGround() {
        return this.getDecodedValue(() -> this.speedOverGround, value -> {
            this.speedOverGround = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.UNSIGNED_FLOAT_DECODER.apply(this.getBits(46, 55)).floatValue() / 10.0f));
    }

    public Boolean getPositionAccurate() {
        return this.getDecodedValue(() -> this.positionAccurate, value -> {
            this.positionAccurate = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(56, 57)));
    }

    @Override
    public Float getLatitude() {
        return this.getDecodedValue(() -> this.latitude, value -> {
            this.latitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(85, 112)).floatValue() / 600000.0f));
    }

    @Override
    public Float getLongitude() {
        return this.getDecodedValue(() -> this.longitude, value -> {
            this.longitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(57, 85)).floatValue() / 600000.0f));
    }

    @Override
    public Float getCourseOverGround() {
        return this.getDecodedValue(() -> this.courseOverGround, value -> {
            this.courseOverGround = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.UNSIGNED_FLOAT_DECODER.apply(this.getBits(112, 124)).floatValue() / 10.0f));
    }

    @Override
    public Integer getTrueHeading() {
        return this.getDecodedValue(() -> this.trueHeading, value -> {
            this.trueHeading = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(124, 133)));
    }

    @Override
    public Integer getSecond() {
        return this.getDecodedValue(() -> this.second, value -> {
            this.second = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(133, 139)));
    }

    public String getRegionalReserved2() {
        return this.getDecodedValue(() -> this.regionalReserved2, value -> {
            this.regionalReserved2 = value;
        }, () -> Boolean.TRUE, () -> Decoders.BIT_DECODER.apply(this.getBits(139, 143)));
    }

    public String getShipName() {
        return this.getDecodedValue(() -> this.shipName, value -> {
            this.shipName = value;
        }, () -> Boolean.TRUE, () -> Decoders.STRING_DECODER.apply(this.getBits(143, 263)));
    }

    public ShipType getShipType() {
        return this.getDecodedValue(() -> this.shipType, value -> {
            this.shipType = value;
        }, () -> Boolean.TRUE, () -> ShipType.fromInteger(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(263, 271))));
    }

    public Integer getToBow() {
        return this.getDecodedValue(() -> this.toBow, value -> {
            this.toBow = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(271, 280)));
    }

    public Integer getToStern() {
        return this.getDecodedValue(() -> this.toStern, value -> {
            this.toStern = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(280, 289)));
    }

    public Integer getToStarboard() {
        return this.getDecodedValue(() -> this.toStarboard, value -> {
            this.toStarboard = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(295, 301)));
    }

    public Integer getToPort() {
        return this.getDecodedValue(() -> this.toPort, value -> {
            this.toPort = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(289, 295)));
    }

    public PositionFixingDevice getPositionFixingDevice() {
        return this.getDecodedValue(() -> this.positionFixingDevice, value -> {
            this.positionFixingDevice = value;
        }, () -> Boolean.TRUE, () -> PositionFixingDevice.fromInteger(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(301, 305))));
    }

    public Boolean getRaimFlag() {
        return this.getDecodedValue(() -> this.raimFlag, value -> {
            this.raimFlag = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(305, 306)));
    }

    public Boolean getDataTerminalReady() {
        return this.getDecodedValue(() -> this.dataTerminalReady, value -> {
            this.dataTerminalReady = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(306, 307)));
    }

    public Boolean getAssigned() {
        return this.getDecodedValue(() -> this.assigned, value -> {
            this.assigned = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(307, 308)));
    }

    @Override
    public String toString() {
        return "ExtendedClassBEquipmentPositionReport{messageType=" + (Object)((Object)this.getMessageType()) + ", regionalReserved1='" + this.getRegionalReserved1() + '\'' + ", speedOverGround=" + this.getSpeedOverGround() + ", positionAccurate=" + this.getPositionAccurate() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", courseOverGround=" + this.getCourseOverGround() + ", trueHeading=" + this.getTrueHeading() + ", second=" + this.getSecond() + ", regionalReserved2='" + this.getRegionalReserved2() + '\'' + ", shipName='" + this.getShipName() + '\'' + ", shipType=" + (Object)((Object)this.getShipType()) + ", toBow=" + this.getToBow() + ", toStern=" + this.getToStern() + ", toStarboard=" + this.getToStarboard() + ", toPort=" + this.getToPort() + ", positionFixingDevice=" + (Object)((Object)this.getPositionFixingDevice()) + ", raimFlag=" + this.getRaimFlag() + ", dataTerminalReady=" + this.getDataTerminalReady() + ", assigned=" + this.getAssigned() + "} " + super.toString();
    }
}

