/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.messages.AISMessage;
import dk.tbsalling.aismessages.ais.messages.types.AISMessageType;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;

public class GNSSBinaryBroadcastMessage
extends AISMessage {
    private transient Integer spare1;
    private transient Float latitude;
    private transient Float longitude;
    private transient Integer spare2;
    private transient Integer mType;
    private transient Integer stationId;
    private transient Integer zCount;
    private transient Integer sequenceNumber;
    private transient Integer numOfWords;
    private transient Integer health;
    private transient String binaryData;

    public GNSSBinaryBroadcastMessage(NMEAMessage[] nmeaMessages) {
        super(nmeaMessages);
    }

    protected GNSSBinaryBroadcastMessage(NMEAMessage[] nmeaMessages, String bitString) {
        super(nmeaMessages, bitString);
    }

    @Override
    protected void checkAISMessage() {
    }

    @Override
    public final AISMessageType getMessageType() {
        return AISMessageType.GNSSBinaryBroadcastMessage;
    }

    public Integer getSpare1() {
        return this.getDecodedValue(() -> this.spare1, value -> {
            this.spare1 = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(38, 40)));
    }

    public Float getLatitude() {
        return this.getDecodedValue(() -> this.latitude, value -> {
            this.latitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(58, 75)).floatValue() / 10.0f));
    }

    public Float getLongitude() {
        return this.getDecodedValue(() -> this.longitude, value -> {
            this.longitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(40, 58)).floatValue() / 10.0f));
    }

    public Integer getSpare2() {
        return this.getDecodedValue(() -> this.spare2, value -> {
            this.spare2 = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(75, 80)));
    }

    public Integer getMType() {
        return this.getDecodedValue(() -> this.mType, value -> {
            this.mType = value;
        }, () -> this.getNumberOfBits() > 80, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(80, 86)));
    }

    public Integer getStationId() {
        return this.getDecodedValue(() -> this.stationId, value -> {
            this.stationId = value;
        }, () -> this.getNumberOfBits() > 80, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(86, 96)));
    }

    public Integer getZCount() {
        return this.getDecodedValue(() -> this.zCount, value -> {
            this.zCount = value;
        }, () -> this.getNumberOfBits() > 80, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(96, 109)));
    }

    public Integer getSequenceNumber() {
        return this.getDecodedValue(() -> this.sequenceNumber, value -> {
            this.sequenceNumber = value;
        }, () -> this.getNumberOfBits() > 80, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(109, 112)));
    }

    public Integer getNumOfWords() {
        return this.getDecodedValue(() -> this.numOfWords, value -> {
            this.numOfWords = value;
        }, () -> this.getNumberOfBits() > 80, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(112, 117)));
    }

    public Integer getHealth() {
        return this.getDecodedValue(() -> this.health, value -> {
            this.health = value;
        }, () -> this.getNumberOfBits() > 80, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(117, 120)));
    }

    public String getBinaryData() {
        return this.getDecodedValue(() -> this.binaryData, value -> {
            this.binaryData = value;
        }, () -> this.getNumberOfBits() > 80, () -> Decoders.BIT_DECODER.apply(this.getBits(80, this.getNumberOfBits())));
    }

    @Override
    public String toString() {
        return "GNSSBinaryBroadcastMessage{messageType=" + (Object)((Object)this.getMessageType()) + ", spare1=" + this.getSpare1() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", spare2=" + this.getSpare2() + ", mType=" + this.getMType() + ", stationId=" + this.getStationId() + ", zCount=" + this.getZCount() + ", sequenceNumber=" + this.getSequenceNumber() + ", numOfWords=" + this.getNumOfWords() + ", health=" + this.getHealth() + ", binaryData='" + this.getBinaryData() + '\'' + "} " + super.toString();
    }
}

