/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.messages.AISMessage;
import dk.tbsalling.aismessages.ais.messages.ExtendedDynamicDataReport;
import dk.tbsalling.aismessages.ais.messages.PositionReportClassAAssignedSchedule;
import dk.tbsalling.aismessages.ais.messages.PositionReportClassAResponseToInterrogation;
import dk.tbsalling.aismessages.ais.messages.PositionReportClassAScheduled;
import dk.tbsalling.aismessages.ais.messages.types.CommunicationState;
import dk.tbsalling.aismessages.ais.messages.types.ITDMACommunicationState;
import dk.tbsalling.aismessages.ais.messages.types.ManeuverIndicator;
import dk.tbsalling.aismessages.ais.messages.types.NavigationStatus;
import dk.tbsalling.aismessages.ais.messages.types.SOTDMACommunicationState;
import dk.tbsalling.aismessages.ais.messages.types.TransponderClass;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;
import java.lang.ref.WeakReference;

public abstract class PositionReport
extends AISMessage
implements ExtendedDynamicDataReport {
    private transient NavigationStatus navigationStatus;
    private transient Integer rateOfTurn;
    private transient Float speedOverGround;
    private transient Boolean positionAccuracy;
    private transient Float latitude;
    private transient Float longitude;
    private transient Float courseOverGround;
    private transient Integer trueHeading;
    private transient Integer second;
    private transient ManeuverIndicator specialManeuverIndicator;
    private transient Boolean raimFlag;
    private transient WeakReference<CommunicationState> communicationState;

    public PositionReport(NMEAMessage[] nmeaMessages) {
        super(nmeaMessages);
    }

    protected PositionReport(NMEAMessage[] nmeaMessages, String bitString) {
        super(nmeaMessages, bitString);
    }

    @Override
    protected void checkAISMessage() {
    }

    @Override
    public TransponderClass getTransponderClass() {
        return TransponderClass.A;
    }

    public NavigationStatus getNavigationStatus() {
        return this.getDecodedValue(() -> this.navigationStatus, value -> {
            this.navigationStatus = value;
        }, () -> Boolean.TRUE, () -> NavigationStatus.fromInteger(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(38, 42))));
    }

    public Integer getRateOfTurn() {
        return this.getDecodedValue(() -> this.rateOfTurn, value -> {
            this.rateOfTurn = value;
        }, () -> Boolean.TRUE, () -> Decoders.INTEGER_DECODER.apply(this.getBits(42, 50)));
    }

    @Override
    public Float getSpeedOverGround() {
        return this.getDecodedValue(() -> this.speedOverGround, value -> {
            this.speedOverGround = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.UNSIGNED_FLOAT_DECODER.apply(this.getBits(50, 60)).floatValue() / 10.0f));
    }

    public Boolean getPositionAccuracy() {
        return this.getDecodedValue(() -> this.positionAccuracy, value -> {
            this.positionAccuracy = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(60, 61)));
    }

    @Override
    public Float getLatitude() {
        return this.getDecodedValue(() -> this.latitude, value -> {
            this.latitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(89, 116)).floatValue() / 600000.0f));
    }

    @Override
    public Float getLongitude() {
        return this.getDecodedValue(() -> this.longitude, value -> {
            this.longitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(61, 89)).floatValue() / 600000.0f));
    }

    @Override
    public Float getCourseOverGround() {
        return this.getDecodedValue(() -> this.courseOverGround, value -> {
            this.courseOverGround = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.UNSIGNED_FLOAT_DECODER.apply(this.getBits(116, 128)).floatValue() / 10.0f));
    }

    @Override
    public Integer getTrueHeading() {
        return this.getDecodedValue(() -> this.trueHeading, value -> {
            this.trueHeading = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(128, 137)));
    }

    @Override
    public Integer getSecond() {
        return this.getDecodedValue(() -> this.second, value -> {
            this.second = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(137, 143)));
    }

    public ManeuverIndicator getSpecialManeuverIndicator() {
        return this.getDecodedValue(() -> this.specialManeuverIndicator, value -> {
            this.specialManeuverIndicator = value;
        }, () -> Boolean.TRUE, () -> ManeuverIndicator.fromInteger(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(143, 145))));
    }

    public Boolean getRaimFlag() {
        return this.getDecodedValue(() -> this.raimFlag, value -> {
            this.raimFlag = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(148, 149)));
    }

    public CommunicationState getCommunicationState() {
        if (this instanceof PositionReportClassAScheduled || this instanceof PositionReportClassAAssignedSchedule) {
            return this.getDecodedValueByWeakReference(() -> this.communicationState, value -> {
                this.communicationState = value;
            }, () -> Boolean.TRUE, () -> SOTDMACommunicationState.fromBitString(this.getBits(149, 168)));
        }
        if (this instanceof PositionReportClassAResponseToInterrogation) {
            return this.getDecodedValueByWeakReference(() -> this.communicationState, value -> {
                this.communicationState = value;
            }, () -> Boolean.TRUE, () -> ITDMACommunicationState.fromBitString(this.getBits(149, 168)));
        }
        return null;
    }

    @Override
    public String toString() {
        return "PositionReport{navigationStatus=" + (Object)((Object)this.getNavigationStatus()) + ", rateOfTurn=" + this.getRateOfTurn() + ", speedOverGround=" + this.getSpeedOverGround() + ", positionAccuracy=" + this.getPositionAccuracy() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", courseOverGround=" + this.getCourseOverGround() + ", trueHeading=" + this.getTrueHeading() + ", second=" + this.getSecond() + ", specialManeuverIndicator=" + (Object)((Object)this.getSpecialManeuverIndicator()) + ", raimFlag=" + this.getRaimFlag() + "} " + super.toString();
    }
}

