/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.exceptions.UnsupportedMessageType;
import dk.tbsalling.aismessages.ais.messages.AISMessage;
import dk.tbsalling.aismessages.ais.messages.StaticDataReport;
import dk.tbsalling.aismessages.ais.messages.types.AISMessageType;
import dk.tbsalling.aismessages.ais.messages.types.IMO;
import dk.tbsalling.aismessages.ais.messages.types.PositionFixingDevice;
import dk.tbsalling.aismessages.ais.messages.types.ShipType;
import dk.tbsalling.aismessages.ais.messages.types.TransponderClass;
import dk.tbsalling.aismessages.nmea.exceptions.InvalidMessage;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;

public class ShipAndVoyageData
extends AISMessage
implements StaticDataReport {
    private transient IMO imo;
    private transient String callsign;
    private transient String shipName;
    private transient ShipType shipType;
    private transient Integer toBow;
    private transient Integer toStern;
    private transient Integer toStarboard;
    private transient Integer toPort;
    private transient PositionFixingDevice positionFixingDevice;
    private transient String eta;
    private transient Float draught;
    private transient String destination;
    private transient Boolean dataTerminalReady;

    public ShipAndVoyageData(NMEAMessage[] nmeaMessages) {
        super(nmeaMessages);
    }

    protected ShipAndVoyageData(NMEAMessage[] nmeaMessages, String bitString) {
        super(nmeaMessages, bitString);
    }

    @Override
    protected void checkAISMessage() {
        AISMessageType messageType = this.getMessageType();
        if (messageType != AISMessageType.ShipAndVoyageRelatedData) {
            throw new UnsupportedMessageType(messageType.getCode());
        }
        int numberOfBits = this.getNumberOfBits();
        if (numberOfBits != 424 && numberOfBits != 422) {
            throw new InvalidMessage("Message of type " + (Object)((Object)messageType) + " expected to be 424 bits long; not " + numberOfBits);
        }
    }

    @Override
    public final AISMessageType getMessageType() {
        return AISMessageType.ShipAndVoyageRelatedData;
    }

    @Override
    public TransponderClass getTransponderClass() {
        return TransponderClass.A;
    }

    public IMO getImo() {
        return this.getDecodedValue(() -> this.imo, value -> {
            this.imo = value;
        }, () -> Boolean.TRUE, () -> IMO.valueOf(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(40, 70))));
    }

    @Override
    public String getCallsign() {
        return this.getDecodedValue(() -> this.callsign, value -> {
            this.callsign = value;
        }, () -> Boolean.TRUE, () -> Decoders.STRING_DECODER.apply(this.getBits(70, 112)));
    }

    @Override
    public String getShipName() {
        return this.getDecodedValue(() -> this.shipName, value -> {
            this.shipName = value;
        }, () -> Boolean.TRUE, () -> Decoders.STRING_DECODER.apply(this.getBits(112, 232)));
    }

    @Override
    public ShipType getShipType() {
        return this.getDecodedValue(() -> this.shipType, value -> {
            this.shipType = value;
        }, () -> Boolean.TRUE, () -> ShipType.fromInteger(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(232, 240))));
    }

    @Override
    public Integer getToBow() {
        return this.getDecodedValue(() -> this.toBow, value -> {
            this.toBow = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(240, 249)));
    }

    @Override
    public Integer getToStern() {
        return this.getDecodedValue(() -> this.toStern, value -> {
            this.toStern = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(249, 258)));
    }

    @Override
    public Integer getToStarboard() {
        return this.getDecodedValue(() -> this.toStarboard, value -> {
            this.toStarboard = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(264, 270)));
    }

    @Override
    public Integer getToPort() {
        return this.getDecodedValue(() -> this.toPort, value -> {
            this.toPort = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(258, 264)));
    }

    public PositionFixingDevice getPositionFixingDevice() {
        return this.getDecodedValue(() -> this.positionFixingDevice, value -> {
            this.positionFixingDevice = value;
        }, () -> Boolean.TRUE, () -> PositionFixingDevice.fromInteger(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(270, 274))));
    }

    public String getEta() {
        return this.getDecodedValue(() -> this.eta, value -> {
            this.eta = value;
        }, () -> Boolean.TRUE, () -> Decoders.TIME_DECODER.apply(this.getBits(274, 294)));
    }

    public Float getDraught() {
        return this.getDecodedValue(() -> this.draught, value -> {
            this.draught = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.UNSIGNED_FLOAT_DECODER.apply(this.getBits(294, 302)).floatValue() / 10.0f));
    }

    public String getDestination() {
        return this.getDecodedValue(() -> this.destination, value -> {
            this.destination = value;
        }, () -> Boolean.TRUE, () -> Decoders.STRING_DECODER.apply(this.getBits(302, 422)));
    }

    public Boolean getDataTerminalReady() {
        return this.getDecodedValue(() -> this.dataTerminalReady, value -> {
            this.dataTerminalReady = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(422, 423)));
    }

    @Override
    public String toString() {
        return "ShipAndVoyageData{messageType=" + (Object)((Object)this.getMessageType()) + ", imo=" + this.getImo() + ", callsign='" + this.getCallsign() + '\'' + ", shipName='" + this.getShipName() + '\'' + ", shipType=" + (Object)((Object)this.getShipType()) + ", toBow=" + this.getToBow() + ", toStern=" + this.getToStern() + ", toStarboard=" + this.getToStarboard() + ", toPort=" + this.getToPort() + ", positionFixingDevice=" + (Object)((Object)this.getPositionFixingDevice()) + ", eta='" + this.getEta() + '\'' + ", draught=" + this.getDraught() + ", destination='" + this.getDestination() + '\'' + ", dataTerminalReady=" + this.getDataTerminalReady() + "} " + super.toString();
    }
}

