/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.messages.AISMessage;
import dk.tbsalling.aismessages.ais.messages.ExtendedDynamicDataReport;
import dk.tbsalling.aismessages.ais.messages.types.AISMessageType;
import dk.tbsalling.aismessages.ais.messages.types.CommunicationState;
import dk.tbsalling.aismessages.ais.messages.types.ITDMACommunicationState;
import dk.tbsalling.aismessages.ais.messages.types.SOTDMACommunicationState;
import dk.tbsalling.aismessages.ais.messages.types.TransponderClass;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;
import java.lang.ref.WeakReference;

public class StandardClassBCSPositionReport
extends AISMessage
implements ExtendedDynamicDataReport {
    private transient String regionalReserved1;
    private transient Float speedOverGround;
    private transient Boolean positionAccurate;
    private transient Float latitude;
    private transient Float longitude;
    private transient Float courseOverGround;
    private transient Integer trueHeading;
    private transient Integer second;
    private transient String regionalReserved2;
    private transient Boolean csUnit;
    private transient Boolean display;
    private transient Boolean dsc;
    private transient Boolean band;
    private transient Boolean message22;
    private transient Boolean assigned;
    private transient Boolean raimFlag;
    private transient Boolean commStateSelectorFlag;
    private transient WeakReference<CommunicationState> communicationState;

    public StandardClassBCSPositionReport(NMEAMessage[] nmeaMessages) {
        super(nmeaMessages);
    }

    protected StandardClassBCSPositionReport(NMEAMessage[] nmeaMessages, String bitString) {
        super(nmeaMessages, bitString);
    }

    @Override
    protected void checkAISMessage() {
    }

    @Override
    public final AISMessageType getMessageType() {
        return AISMessageType.StandardClassBCSPositionReport;
    }

    @Override
    public TransponderClass getTransponderClass() {
        return TransponderClass.B;
    }

    public String getRegionalReserved1() {
        return this.getDecodedValue(() -> this.regionalReserved1, value -> {
            this.regionalReserved1 = value;
        }, () -> Boolean.TRUE, () -> Decoders.BIT_DECODER.apply(this.getBits(38, 46)));
    }

    @Override
    public Float getSpeedOverGround() {
        return this.getDecodedValue(() -> this.speedOverGround, value -> {
            this.speedOverGround = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.UNSIGNED_FLOAT_DECODER.apply(this.getBits(46, 56)).floatValue() / 10.0f));
    }

    public Boolean getPositionAccurate() {
        return this.getDecodedValue(() -> this.positionAccurate, value -> {
            this.positionAccurate = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(56, 57)));
    }

    @Override
    public Float getLatitude() {
        return this.getDecodedValue(() -> this.latitude, value -> {
            this.latitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(85, 112)).floatValue() / 600000.0f));
    }

    @Override
    public Float getLongitude() {
        return this.getDecodedValue(() -> this.longitude, value -> {
            this.longitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(57, 85)).floatValue() / 600000.0f));
    }

    @Override
    public Float getCourseOverGround() {
        return this.getDecodedValue(() -> this.courseOverGround, value -> {
            this.courseOverGround = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.UNSIGNED_FLOAT_DECODER.apply(this.getBits(112, 124)).floatValue() / 10.0f));
    }

    @Override
    public Integer getTrueHeading() {
        return this.getDecodedValue(() -> this.trueHeading, value -> {
            this.trueHeading = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(124, 133)));
    }

    @Override
    public Integer getSecond() {
        return this.getDecodedValue(() -> this.second, value -> {
            this.second = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(133, 139)));
    }

    public String getRegionalReserved2() {
        return this.getDecodedValue(() -> this.regionalReserved2, value -> {
            this.regionalReserved2 = value;
        }, () -> Boolean.TRUE, () -> Decoders.BIT_DECODER.apply(this.getBits(139, 141)));
    }

    public Boolean getCsUnit() {
        return this.getDecodedValue(() -> this.csUnit, value -> {
            this.csUnit = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(141, 142)));
    }

    public Boolean getDisplay() {
        return this.getDecodedValue(() -> this.display, value -> {
            this.display = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(142, 143)));
    }

    public Boolean getDsc() {
        return this.getDecodedValue(() -> this.dsc, value -> {
            this.dsc = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(143, 144)));
    }

    public Boolean getBand() {
        return this.getDecodedValue(() -> this.band, value -> {
            this.band = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(144, 145)));
    }

    public Boolean getMessage22() {
        return this.getDecodedValue(() -> this.message22, value -> {
            this.message22 = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(145, 146)));
    }

    public Boolean getAssigned() {
        return this.getDecodedValue(() -> this.assigned, value -> {
            this.assigned = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(146, 147)));
    }

    public Boolean getRaimFlag() {
        return this.getDecodedValue(() -> this.raimFlag, value -> {
            this.raimFlag = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(147, 148)));
    }

    public Boolean getCommunicationStateSelectorFlag() {
        return this.getDecodedValue(() -> this.commStateSelectorFlag, value -> {
            this.commStateSelectorFlag = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(148, 149)));
    }

    public CommunicationState getCommunicationState() {
        if (this.getCommunicationStateSelectorFlag() == Boolean.FALSE) {
            return this.getDecodedValueByWeakReference(() -> this.communicationState, value -> {
                this.communicationState = value;
            }, () -> Boolean.TRUE, () -> SOTDMACommunicationState.fromBitString(this.getBits(149, 168)));
        }
        return this.getDecodedValueByWeakReference(() -> this.communicationState, value -> {
            this.communicationState = value;
        }, () -> Boolean.TRUE, () -> ITDMACommunicationState.fromBitString(this.getBits(149, 168)));
    }

    @Override
    public String toString() {
        return "StandardClassBCSPositionReport{messageType=" + (Object)((Object)this.getMessageType()) + ", regionalReserved1='" + this.getRegionalReserved1() + '\'' + ", speedOverGround=" + this.getSpeedOverGround() + ", positionAccurate=" + this.getPositionAccurate() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", courseOverGround=" + this.getCourseOverGround() + ", trueHeading=" + this.getTrueHeading() + ", second=" + this.getSecond() + ", regionalReserved2='" + this.getRegionalReserved2() + '\'' + ", csUnit=" + this.getCsUnit() + ", display=" + this.getDisplay() + ", dsc=" + this.getDsc() + ", band=" + this.getBand() + ", message22=" + this.getMessage22() + ", assigned=" + this.getAssigned() + ", raimFlag=" + this.getRaimFlag() + ", commStateSelectorFlag=" + this.getCommunicationStateSelectorFlag() + ", commState=" + this.getCommunicationState() + "} " + super.toString();
    }
}

