/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.messages.AISMessage;
import dk.tbsalling.aismessages.ais.messages.DynamicDataReport;
import dk.tbsalling.aismessages.ais.messages.types.AISMessageType;
import dk.tbsalling.aismessages.ais.messages.types.TransponderClass;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;

public class StandardSARAircraftPositionReport
extends AISMessage
implements DynamicDataReport {
    private transient Integer altitude;
    private transient Float speed;
    private transient Boolean positionAccurate;
    private transient Float latitude;
    private transient Float longitude;
    private transient Float courseOverGround;
    private transient Integer second;
    private transient String regionalReserved;
    private transient Boolean dataTerminalReady;
    private transient Boolean assigned;
    private transient Boolean raimFlag;
    private transient String radioStatus;

    public StandardSARAircraftPositionReport(NMEAMessage[] nmeaMessages) {
        super(nmeaMessages);
    }

    protected StandardSARAircraftPositionReport(NMEAMessage[] nmeaMessages, String bitString) {
        super(nmeaMessages, bitString);
    }

    @Override
    protected void checkAISMessage() {
    }

    @Override
    public AISMessageType getMessageType() {
        return AISMessageType.StandardSARAircraftPositionReport;
    }

    @Override
    public TransponderClass getTransponderClass() {
        return TransponderClass.SAR;
    }

    public Integer getAltitude() {
        return this.getDecodedValue(() -> this.altitude, value -> {
            this.altitude = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(38, 50)));
    }

    @Override
    public Float getSpeedOverGround() {
        return this.getDecodedValue(() -> this.speed, value -> {
            this.speed = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(50, 60)).intValue()));
    }

    public Boolean getPositionAccurate() {
        return this.getDecodedValue(() -> this.positionAccurate, value -> {
            this.positionAccurate = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(60, 61)));
    }

    @Override
    public Float getLongitude() {
        return this.getDecodedValue(() -> this.longitude, value -> {
            this.longitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(61, 89)).floatValue() / 600000.0f));
    }

    @Override
    public Float getLatitude() {
        return this.getDecodedValue(() -> this.latitude, value -> {
            this.latitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(89, 116)).floatValue() / 600000.0f));
    }

    @Override
    public Float getCourseOverGround() {
        return this.getDecodedValue(() -> this.courseOverGround, value -> {
            this.courseOverGround = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.UNSIGNED_FLOAT_DECODER.apply(this.getBits(116, 128)).floatValue() / 10.0f));
    }

    public Integer getSecond() {
        return this.getDecodedValue(() -> this.second, value -> {
            this.second = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(128, 134)));
    }

    public String getRegionalReserved() {
        return this.getDecodedValue(() -> this.regionalReserved, value -> {
            this.regionalReserved = value;
        }, () -> Boolean.TRUE, () -> Decoders.BIT_DECODER.apply(this.getBits(134, 142)));
    }

    public Boolean getDataTerminalReady() {
        return this.getDecodedValue(() -> this.dataTerminalReady, value -> {
            this.dataTerminalReady = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(142, 143)));
    }

    public Boolean getAssigned() {
        return this.getDecodedValue(() -> this.assigned, value -> {
            this.assigned = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(146, 147)));
    }

    public Boolean getRaimFlag() {
        return this.getDecodedValue(() -> this.raimFlag, value -> {
            this.raimFlag = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(147, 148)));
    }

    public String getRadioStatus() {
        return this.getDecodedValue(() -> this.radioStatus, value -> {
            this.radioStatus = value;
        }, () -> Boolean.TRUE, () -> Decoders.BIT_DECODER.apply(this.getBits(148, 168)));
    }

    @Override
    public String toString() {
        return "StandardSARAircraftPositionReport{messageType=" + (Object)((Object)this.getMessageType()) + ", altitude=" + this.getAltitude() + ", speed=" + this.getSpeedOverGround() + ", positionAccurate=" + this.getPositionAccurate() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", courseOverGround=" + this.getCourseOverGround() + ", second=" + this.getSecond() + ", regionalReserved='" + this.getRegionalReserved() + '\'' + ", dataTerminalReady=" + this.getDataTerminalReady() + ", assigned=" + this.getAssigned() + ", raimFlag=" + this.getRaimFlag() + ", radioStatus='" + this.getRadioStatus() + '\'' + "} " + super.toString();
    }
}

