/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages.types;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.messages.types.CommunicationState;
import dk.tbsalling.aismessages.ais.messages.types.SyncState;
import java.io.Serializable;
import java.util.Objects;

public class ITDMACommunicationState
extends CommunicationState
implements Serializable {
    private final Integer slotIncrement;
    private final Integer numberOfSlots;
    private final Boolean keepFlag;

    private ITDMACommunicationState(SyncState syncState, Integer slotIncrement, Integer numberOfSlots, Boolean keepFlag) {
        super(syncState);
        this.slotIncrement = slotIncrement;
        this.numberOfSlots = numberOfSlots;
        this.keepFlag = keepFlag;
    }

    public static ITDMACommunicationState fromBitString(String bitString) {
        Objects.requireNonNull(bitString);
        bitString = bitString.trim();
        if (bitString.length() != 19 || !bitString.matches("(0|1)*")) {
            return null;
        }
        return new ITDMACommunicationState(SyncState.fromInteger(Decoders.INTEGER_DECODER.apply(bitString.substring(0, 2))), Decoders.INTEGER_DECODER.apply(bitString.substring(2, 15)), Decoders.INTEGER_DECODER.apply(bitString.substring(15, 18)), Decoders.BOOLEAN_DECODER.apply(bitString.substring(18, 19)));
    }

    public Integer getSlotIncrement() {
        return this.slotIncrement;
    }

    public Integer getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public Boolean getKeepFlag() {
        return this.keepFlag;
    }
}

