/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages.types;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.messages.types.CommunicationState;
import dk.tbsalling.aismessages.ais.messages.types.SyncState;
import java.io.Serializable;
import java.util.Objects;
import java.util.logging.Logger;

public class SOTDMACommunicationState
extends CommunicationState
implements Serializable {
    private static final transient Logger LOG = Logger.getLogger(SOTDMACommunicationState.class.getName());
    private Integer slotTimeout;
    private Integer numberOfReceivedStations;
    private Integer slotNumber;
    private Integer utcHour;
    private Integer utcMinute;
    private Integer slotOffset;

    private SOTDMACommunicationState(SyncState syncState, Integer slotTimeout, Integer numberOfReceivedStations, Integer slotNumber, Integer utcHour, Integer utcMinute, Integer slotOffset) {
        super(syncState);
        this.slotTimeout = slotTimeout;
        this.numberOfReceivedStations = numberOfReceivedStations;
        this.slotNumber = slotNumber;
        this.utcHour = utcHour;
        this.utcMinute = utcMinute;
        this.slotOffset = slotOffset;
    }

    public static SOTDMACommunicationState fromBitString(String bitString) {
        Objects.requireNonNull(bitString);
        bitString = bitString.trim();
        if (bitString.length() != 19 || !bitString.matches("(0|1)*")) {
            return null;
        }
        SyncState syncState = SyncState.fromInteger(Decoders.INTEGER_DECODER.apply(bitString.substring(0, 2)));
        int slotTimeout = Decoders.INTEGER_DECODER.apply(bitString.substring(2, 5));
        Integer numberOfReceivedStations = null;
        Integer slotNumber = null;
        Integer utcHour = null;
        Integer utcMinute = null;
        Integer slotOffset = null;
        if (slotTimeout == 3 || slotTimeout == 5 || slotTimeout == 7) {
            numberOfReceivedStations = Decoders.INTEGER_DECODER.apply(bitString.substring(5, 19));
            if (numberOfReceivedStations < 0 || numberOfReceivedStations > 16383) {
                LOG.warning("numberOfReceivedStations: " + numberOfReceivedStations + ": Out of range.");
            }
        } else if (slotTimeout == 2 || slotTimeout == 4 || slotTimeout == 6) {
            slotNumber = Decoders.INTEGER_DECODER.apply(bitString.substring(5, 19));
            if (slotNumber < 0 || slotNumber > 2249) {
                LOG.warning("slotNumber: " + slotNumber + ": Out of range.");
            }
        } else if (slotTimeout == 1) {
            utcHour = Decoders.INTEGER_DECODER.apply(bitString.substring(5, 10));
            if (utcHour < 0 || utcHour > 23) {
                LOG.warning("utcHour: " + utcHour + ": Out of range.");
            }
            if ((utcMinute = Decoders.INTEGER_DECODER.apply(bitString.substring(10, 17))) < 0 || utcMinute > 59) {
                LOG.warning("utcMinute: " + utcMinute + ": Out of range.");
            }
        } else if (slotTimeout == 0) {
            slotOffset = Decoders.INTEGER_DECODER.apply(bitString.substring(5, 19));
        }
        return new SOTDMACommunicationState(syncState, slotTimeout, numberOfReceivedStations, slotNumber, utcHour, utcMinute, slotOffset);
    }

    public Integer getSlotTimeout() {
        return this.slotTimeout;
    }

    public Integer getNumberOfReceivedStations() {
        return this.numberOfReceivedStations;
    }

    public Integer getSlotNumber() {
        return this.slotNumber;
    }

    public Integer getUtcHour() {
        return this.utcHour;
    }

    public Integer getUtcMinute() {
        return this.utcMinute;
    }

    public Integer getSlotOffset() {
        return this.slotOffset;
    }
}

