/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.nmea;

import dk.tbsalling.aismessages.nmea.NMEAMessageInputStreamReader;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class NMEAMessageSocketClient {
    private static final Logger log = Logger.getLogger(NMEAMessageSocketClient.class.getName());
    private NMEAMessageInputStreamReader streamReader;
    private final SocketAddress socketAddress;
    private final Consumer<? super NMEAMessage> nmeaMessageConsumer;

    private NMEAMessageSocketClient() {
        this.socketAddress = null;
        this.nmeaMessageConsumer = null;
    }

    public NMEAMessageSocketClient(String host, Integer port, Consumer<? super NMEAMessage> nmeaMessageConsumer) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(host);
        this.socketAddress = new InetSocketAddress(inetAddress, (int)port);
        this.nmeaMessageConsumer = nmeaMessageConsumer;
    }

    public void requestStop() {
        if (this.streamReader != null) {
            this.streamReader.requestStop();
        }
    }

    public void run() throws IOException {
        log.info("NMEAMessageSocketClient running.");
        Socket socket = new Socket();
        socket.connect(this.socketAddress);
        log.info("Connected to AIS server on " + this.socketAddress.toString());
        InputStream inputStream = socket.getInputStream();
        this.streamReader = new NMEAMessageInputStreamReader(inputStream, this.nmeaMessageConsumer);
        this.streamReader.run();
        log.info("NMEAMessageSocketClient stopping.");
    }
}

