/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class QPTreeTransformer
implements TreeTransformer {
    @Override
    public Tree transformTree(Tree t) {
        return QPTreeTransformer.QPtransform(t);
    }

    public static Tree QPtransform(Tree t) {
        QPTreeTransformer.doTransform(t);
        return t;
    }

    private static void doTransform(Tree t) {
        block7: {
            block8: {
                int i;
                if (!t.value().startsWith("QP")) break block8;
                List<Tree> children = t.getChildrenAsList();
                if (children.size() >= 3 && children.get(0).isPreTerminal()) {
                    String child1 = children.get(0).value();
                    String child2 = children.get(1).value();
                    String child3 = children.get(2).value();
                    if ((child3.startsWith("CD") || child3.startsWith("DT")) && (child1.startsWith("RB") || child1.startsWith("JJ") || child1.startsWith("IN")) && (child2.startsWith("IN") || child2.startsWith("JJ"))) {
                        QPTreeTransformer.transformQP(t);
                        children = t.getChildrenAsList();
                    }
                }
                if (children.size() < 3) break block7;
                boolean flat = true;
                for (i = 0; i < children.size(); ++i) {
                    if (children.get(i).isPreTerminal()) continue;
                    flat = false;
                    break;
                }
                if (flat) {
                    for (i = 1; i < children.size() - 1; ++i) {
                        if (!children.get(i).value().startsWith("CC")) continue;
                        QPTreeTransformer.transformCC(t, children.subList(0, i), children.get(i), children.subList(i + 1, children.size()));
                        break block7;
                    }
                }
                break block7;
            }
            if (t.isPhrasal()) {
                for (Tree child : t.children()) {
                    QPTreeTransformer.doTransform(child);
                }
            }
        }
    }

    private static void transformCC(Tree t, List<Tree> left, Tree conj, List<Tree> right) {
        TreeFactory tf = t.treeFactory();
        LabelFactory lf = t.label().labelFactory();
        Tree leftQP = tf.newTreeNode(lf.newLabel("NP"), left);
        Tree rightQP = tf.newTreeNode(lf.newLabel("NP"), right);
        ArrayList<Tree> newChildren = new ArrayList<Tree>();
        newChildren.add(leftQP);
        newChildren.add(conj);
        newChildren.add(rightQP);
        t.setChildren(newChildren);
    }

    private static void transformQP(Tree t) {
        int i;
        List<Tree> children = t.getChildrenAsList();
        TreeFactory tf = t.treeFactory();
        LabelFactory lf = t.label().labelFactory();
        Tree left = tf.newTreeNode(lf.newLabel("XS"), null);
        for (i = 0; i < 2; ++i) {
            left.addChild(children.get(i));
        }
        for (i = 0; i < 2; ++i) {
            t.removeChild(0);
        }
        t.addChild(0, left);
    }

    public static void main(String[] args) {
        QPTreeTransformer transformer = new QPTreeTransformer();
        MemoryTreebank tb = new MemoryTreebank();
        Properties props = StringUtils.argsToProperties(args);
        String treeFileName = props.getProperty("treeFile");
        if (treeFileName != null) {
            try {
                Tree t;
                PennTreeReader tr = new PennTreeReader(new BufferedReader(new InputStreamReader(new FileInputStream(treeFileName))), new LabeledScoredTreeFactory());
                while ((t = tr.readTree()) != null) {
                    ((AbstractCollection)tb).add(t);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("File problem: " + e);
            }
        }
        for (Tree t : tb) {
            System.out.println("Original tree");
            t.pennPrint();
            System.out.println();
            System.out.println("Tree transformed");
            Tree tree = transformer.transformTree(t);
            tree.pennPrint();
            System.out.println();
            System.out.println("----------------------------");
        }
    }
}

