/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.logging.RedirectOutputHandler;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.RedwoodConfiguration;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JavaUtilLoggingAdaptor {
    private static boolean addedRedwoodHandler;

    private JavaUtilLoggingAdaptor() {
    }

    public static void adapt() {
        Logger topLogger = Logger.getLogger("");
        Handler oldConsoleHandler = null;
        for (Handler handler : topLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler) || handler instanceof RedwoodHandler) continue;
            oldConsoleHandler = handler;
            break;
        }
        if (oldConsoleHandler != null) {
            topLogger.removeHandler(oldConsoleHandler);
        }
        if (!addedRedwoodHandler) {
            RedwoodHandler redwoodHandler = new RedwoodHandler();
            topLogger.addHandler(redwoodHandler);
            addedRedwoodHandler = true;
        }
        Redwood.addLoggingClass(JavaUtilLoggingAdaptor.class.getCanonicalName());
        Redwood.addLoggingClass("java.util.logging");
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("redwood")) {
            Redwood.log(new Object[]{Redwood.DBG, "at the top"});
            Redwood.startTrack("Adaptor test controlled by redwood");
            Logger topLogger = Logger.getLogger("global");
            topLogger.warning("I'm warning you!");
            topLogger.severe("Now I'm using my severe voice.");
            topLogger.info("FYI");
            Redwood.log(new Object[]{Redwood.DBG, "adapting"});
            JavaUtilLoggingAdaptor.adapt();
            topLogger.warning("I'm warning you in Redwood!");
            JavaUtilLoggingAdaptor.adapt();
            topLogger.severe("Now I'm using my severe voice in Redwood!");
            topLogger.info("FYI: Redwood rocks");
            topLogger.setLevel(Level.OFF);
            topLogger.severe("We shouldn't see this message.");
            Redwood.log(new Object[]{Redwood.DBG, "at the bottom"});
            Redwood.endTrack("Adaptor test controlled by redwood");
        } else {
            Logger topLogger = Logger.getLogger("global");
            Logger logger = Logger.getLogger(JavaUtilLoggingAdaptor.class.getName());
            topLogger.info("Starting test");
            logger.log(Level.INFO, "Hello from the class logger");
            Redwood.log("Hello from Redwood!");
            RedwoodConfiguration.empty().rootHandler(RedirectOutputHandler.fromJavaUtilLogging(topLogger)).apply();
            Redwood.log("Hello from Redwood -> Java!");
            Redwood.log("Hello from Redwood -> Java again!");
            logger.log(Level.INFO, "Hello again from the class logger");
            Redwood.startTrack("a track");
            Redwood.log("Inside a track");
            logger.log(Level.INFO, "Hello a third time from the class logger");
            Redwood.endTrack("a track");
            logger.log(Level.INFO, "Hello a fourth time from the class logger");
        }
    }

    public static class RedwoodHandler
    extends ConsoleHandler {
        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord record) {
            String message = record.getMessage();
            Level level = record.getLevel();
            Redwood.Flag tag = null;
            if (level == Level.WARNING) {
                tag = Redwood.WARN;
            } else if (level == Level.SEVERE) {
                tag = Redwood.ERR;
            } else if (level.intValue() <= Level.FINE.intValue()) {
                tag = Redwood.DBG;
            }
            if (tag == null) {
                Redwood.log(message);
            } else {
                Redwood.log(new Object[]{tag, message});
            }
        }
    }
}

