/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Color;
import edu.stanford.nlp.util.logging.LogRecordHandler;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.Style;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public abstract class OutputHandler
extends LogRecordHandler {
    protected LinkedList<Redwood.Record> queuedTracks = new LinkedList();
    protected Stack<TrackInfo> trackStack = new Stack();
    protected TrackInfo info;
    protected String tab = "  ";
    protected char channelSeparatorChar = (char)32;
    protected int leftMargin = 0;
    protected int minLineCountForTrackNameReminder = 50;
    private boolean missingOpenBracket = false;
    protected Color trackColor = Color.NONE;
    protected Map<String, Color> channelColors = null;
    protected boolean addRandomColors = false;
    protected Style trackStyle = Style.NONE;
    protected Map<String, Style> channelStyles = null;

    public abstract void print(Object[] var1, String var2);

    public void colorChannel(String channel, Color color) {
        if (this.channelColors == null) {
            this.channelColors = Generics.newHashMap();
        }
        this.channelColors.put(channel.toLowerCase(), color);
    }

    public void styleChannel(String channel, Style style) {
        if (this.channelStyles == null) {
            this.channelStyles = Generics.newHashMap();
        }
        this.channelStyles.put(channel.toLowerCase(), style);
    }

    public void setColorChannels(boolean colorChannels) {
        this.addRandomColors = colorChannels;
        if (colorChannels) {
            this.channelColors = Generics.newHashMap();
        }
    }

    protected StringBuilder style(StringBuilder b, String line, Color color, Style style) {
        if (color != Color.NONE || style != Style.NONE) {
            b.append(color.ansiCode);
            b.append(style.ansiCode);
            b.append(line);
            b.append("\u001b[0m");
        } else {
            b.append(line);
        }
        return b;
    }

    protected boolean formatChannel(StringBuilder b, String channelStr, Object channel) {
        if (this.channelColors == null && this.channelStyles == null) {
            b.append(channelStr);
        } else {
            Style candStyle;
            String channelToString = channel.toString().toLowerCase();
            Color color = Color.NONE;
            Style style = Style.NONE;
            if (this.channelColors != null) {
                Color candColor = this.channelColors.get(channelToString);
                if (candColor != null) {
                    color = candColor;
                } else if (this.addRandomColors) {
                    color = Color.values()[Math.abs(channelToString.hashCode()) % (Color.values().length - 3) + 3];
                    if (channelToString.equals(Redwood.ERR.toString().toLowerCase())) {
                        color = Color.RED;
                    } else if (channelToString.equals(Redwood.WARN.toString().toLowerCase())) {
                        color = Color.YELLOW;
                    }
                    this.channelColors.put(channelToString, color);
                }
            }
            if (this.channelStyles != null && (candStyle = this.channelStyles.get(channelToString)) != null) {
                style = candStyle;
            }
            this.style(b, channelStr, color, style);
        }
        return true;
    }

    private void writeContent(int depth, Object content, StringBuilder b) {
        if (this.leftMargin > 2) {
            b.append(this.tab);
        }
        for (int i = 0; i < depth; ++i) {
            b.append(this.tab);
        }
        b.append(content.toString());
    }

    private void updateTracks(int untilDepth) {
        while (!this.queuedTracks.isEmpty()) {
            Redwood.Record signal = this.queuedTracks.removeFirst();
            if (signal.depth >= untilDepth) {
                this.queuedTracks.add(signal);
                return;
            }
            StringBuilder b = new StringBuilder();
            if (this.missingOpenBracket) {
                b.append("{\n");
            }
            for (int i = 0; i < this.leftMargin; ++i) {
                b.append(" ");
            }
            this.writeContent(signal.depth, signal.content, b);
            if (signal.content.toString().length() > 0) {
                b.append(" ");
            }
            this.print(null, this.style(new StringBuilder(), b.toString(), this.trackColor, this.trackStyle).toString());
            this.missingOpenBracket = true;
            if (this.info == null) continue;
            ++this.info.numElementsPrinted;
        }
    }

    @Override
    public List<Redwood.Record> handle(Redwood.Record record) {
        String[] content;
        StringBuilder b = new StringBuilder();
        if (record.content instanceof Throwable) {
            ArrayList<String> lines = new ArrayList<String>();
            StackTraceElement[] trace = null;
            StackTraceElement topTraceElement = null;
            Throwable exception = (Throwable)record.content;
            lines.add(record.content.toString());
            trace = exception.getStackTrace();
            topTraceElement = trace.length > 0 ? trace[0] : null;
            for (StackTraceElement e : exception.getStackTrace()) {
                lines.add(this.tab + e.toString());
            }
            while (exception.getCause() != null) {
                System.out.println("TOP ELEMENT: " + topTraceElement);
                exception = exception.getCause();
                trace = exception.getStackTrace();
                lines.add("Caused by: " + exception.getClass() + ": " + exception.getMessage());
                for (int i = 0; i < trace.length; ++i) {
                    StackTraceElement e = trace[i];
                    lines.add(this.tab + e.toString());
                    if (topTraceElement == null || !e.getClassName().equals(topTraceElement.getClassName()) || !e.getMethodName().equals(topTraceElement.getMethodName())) continue;
                    lines.add(this.tab + "..." + (trace.length - i - 1) + " more");
                    break;
                }
                topTraceElement = trace.length > 0 ? trace[0] : null;
            }
            content = new String[lines.size()];
            content = lines.toArray(content);
        } else {
            content = record.content == null ? new String[]{"null"} : record.content.toString().split("\n");
        }
        this.updateTracks(record.depth);
        if (this.missingOpenBracket) {
            this.style(b, "{\n", this.trackColor, this.trackStyle);
            this.missingOpenBracket = false;
        }
        int cursorPos = 0;
        int contentLinesPrinted = 0;
        Color color = Color.NONE;
        Style style = Style.NONE;
        ArrayList<Object> printableChannels = new ArrayList<Object>();
        for (Object chan : record.channels()) {
            if (chan instanceof Color) {
                color = (Color)((Object)chan);
                continue;
            }
            if (chan instanceof Style) {
                style = (Style)((Object)chan);
                continue;
            }
            if (chan == Redwood.FORCE) continue;
            printableChannels.add(chan);
        }
        if (this.leftMargin > 2) {
            b.append("[");
            ++cursorPos;
            Object lastChan = null;
            boolean wasAnyChannelPrinted = false;
            for (int i = 0; i < printableChannels.size(); ++i) {
                Object chan;
                chan = printableChannels.get(i);
                if (chan.equals(lastChan)) continue;
                lastChan = chan;
                String toPrint = chan.toString();
                if (toPrint.length() > this.leftMargin - 1) {
                    toPrint = toPrint.substring(0, this.leftMargin - 2);
                }
                if (cursorPos + toPrint.length() >= this.leftMargin) {
                    while (cursorPos < this.leftMargin) {
                        b.append(" ");
                        ++cursorPos;
                    }
                    if (contentLinesPrinted < content.length) {
                        this.writeContent(record.depth, this.style(new StringBuilder(), content[contentLinesPrinted], color, style).toString(), b);
                        ++contentLinesPrinted;
                    }
                    b.append("\n ");
                    cursorPos = 1;
                }
                boolean wasChannelPrinted = this.formatChannel(b, toPrint, chan);
                boolean bl = wasAnyChannelPrinted = wasAnyChannelPrinted || wasChannelPrinted;
                if (wasChannelPrinted && i < printableChannels.size() - 1) {
                    b.append(this.channelSeparatorChar);
                    ++cursorPos;
                }
                cursorPos += toPrint.length();
            }
            if (wasAnyChannelPrinted) {
                b.append("]");
                ++cursorPos;
            } else {
                b.setLength(b.length() - 1);
                --cursorPos;
            }
        }
        while (contentLinesPrinted < content.length) {
            while (cursorPos < this.leftMargin) {
                b.append(" ");
                ++cursorPos;
            }
            this.writeContent(record.depth, this.style(new StringBuilder(), content[contentLinesPrinted], color, style).toString(), b);
            if (++contentLinesPrinted >= content.length) continue;
            b.append("\n");
            cursorPos = 0;
        }
        if (b.length() == 0 || b.charAt(b.length() - 1) != '\n') {
            b.append("\n");
        }
        this.print(record.channels(), b.toString());
        if (this.info != null) {
            ++this.info.numElementsPrinted;
        }
        ArrayList<Redwood.Record> rtn = new ArrayList<Redwood.Record>();
        rtn.add(record);
        return rtn;
    }

    @Override
    public List<Redwood.Record> signalStartTrack(Redwood.Record signal) {
        this.queuedTracks.addLast(signal);
        if (this.info != null) {
            this.trackStack.push(this.info);
        }
        this.info = new TrackInfo(signal.content.toString(), signal.timesstamp);
        if (signal.force()) {
            this.updateTracks(signal.depth + 1);
        }
        return EMPTY;
    }

    @Override
    public List<Redwood.Record> signalEndTrack(int newDepth, long timeOfEnd) {
        TrackInfo childInfo = this.info;
        if (childInfo == null) {
            throw new IllegalStateException("OutputHandler received endTrack() without matching startTrack() --are your handlers mis-configured?");
        }
        if (this.trackStack.empty()) {
            this.info = null;
        } else {
            this.info = this.trackStack.pop();
            this.info.numElementsPrinted += childInfo.numElementsPrinted;
        }
        if (this.queuedTracks.isEmpty()) {
            StringBuilder b = new StringBuilder();
            if (!this.missingOpenBracket) {
                for (int i = 0; i < this.leftMargin; ++i) {
                    b.append(" ");
                }
                this.writeContent(newDepth, "", b);
                b.append("} ");
            }
            this.missingOpenBracket = false;
            if (childInfo != null && childInfo.numElementsPrinted > this.minLineCountForTrackNameReminder) {
                b.append("<< ").append(childInfo.name).append(" ");
            }
            if (childInfo != null && timeOfEnd - childInfo.beginTime > 100L) {
                b.append("[");
                Redwood.formatTimeDifference(timeOfEnd - childInfo.beginTime, b);
                b.append("]");
            }
            b.append("\n");
            this.print(null, this.style(new StringBuilder(), b.toString(), this.trackColor, this.trackStyle).toString());
        } else {
            this.queuedTracks.removeLast();
        }
        return EMPTY;
    }

    private static class TrackInfo {
        public final long beginTime;
        public final String name;
        protected int numElementsPrinted = 0;

        private TrackInfo(String name, long timestamp) {
            this.name = name;
            this.beginTime = timestamp;
        }
    }
}

