/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.logging.Redwood;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Timing {
    private static final Redwood.RedwoodChannels log = Redwood.channels(Timing.class);
    private static final long MILLISECONDS_TO_SECONDS = 1000L;
    private static final long SECOND_DIVISOR = 1000000000L;
    private static final long MILLISECOND_DIVISOR = 1000000L;
    private long start;
    private static long startTime = System.nanoTime();
    private static final NumberFormat nf = new DecimalFormat("0.0");

    public Timing() {
        this.start();
    }

    public void start() {
        this.start = System.nanoTime();
    }

    public long report() {
        return (System.nanoTime() - this.start) / 1000000L;
    }

    public long reportNano() {
        return System.nanoTime() - this.start;
    }

    public long report(String str, PrintStream stream) {
        long elapsed = this.report();
        stream.println(str + " Time elapsed: " + elapsed + " ms");
        return elapsed;
    }

    public long report(String str) {
        return this.report(str, System.err);
    }

    public long report(String str, PrintWriter writer) {
        long elapsed = this.report();
        writer.println(str + " Time elapsed: " + elapsed + " ms");
        return elapsed;
    }

    public String toSecondsString() {
        return Timing.toSecondsString(this.report());
    }

    public static String toSecondsString(long elapsed) {
        return nf.format((double)elapsed / 1000.0);
    }

    public static String toMilliSecondsString(long elapsed) {
        return nf.format(elapsed);
    }

    public long restart() {
        long elapsed = this.report();
        this.start();
        return elapsed;
    }

    public long restart(String str, PrintStream stream) {
        long elapsed = this.report(str, stream);
        this.start();
        return elapsed;
    }

    public long restart(String str) {
        return this.restart(str, System.err);
    }

    public long restart(String str, PrintWriter writer) {
        long elapsed = this.report(str, writer);
        this.start();
        return elapsed;
    }

    public void end(String msg) {
        long elapsed = System.nanoTime() - this.start;
        log.info(msg + " done [" + nf.format((double)elapsed / 1.0E9) + " sec].");
        this.start();
    }

    public long stop() {
        long elapsed = this.report();
        this.start = 0L;
        return elapsed;
    }

    public long stop(String str, PrintStream stream) {
        this.report(str, stream);
        return this.stop();
    }

    public long stop(String str) {
        return this.stop(str, System.err);
    }

    public long stop(String str, PrintWriter writer) {
        this.report(str, writer);
        return this.stop();
    }

    public static void startTime() {
        startTime = System.nanoTime();
    }

    public static long endTime() {
        return (System.nanoTime() - startTime) / 1000000L;
    }

    public static long endTime(String str, PrintStream stream) {
        long elapsed = Timing.endTime();
        stream.println(str + " Time elapsed: " + elapsed + " ms");
        return elapsed;
    }

    public static long endTime(String str) {
        return Timing.endTime(str, System.err);
    }

    public void doing(String str) {
        log.info(str + " ... ");
        this.start();
    }

    public void done() {
        log.info("done [" + this.toSecondsString() + " sec].");
    }

    public void done(String msg) {
        log.info(msg + " done [" + this.toSecondsString() + " sec].");
    }

    public void done(StringBuilder msg) {
        msg.append(" done [").append(this.toSecondsString()).append(" sec].");
        log.info(msg.toString());
    }

    public void done(Redwood.RedwoodChannels logger, StringBuilder msg) {
        msg.append("... done [").append(this.toSecondsString()).append(" sec].");
        logger.info(msg.toString());
    }

    public void done(Redwood.RedwoodChannels logger, String msg) {
        logger.info(msg + " ... done [" + this.toSecondsString() + " sec].");
    }

    public static void startDoing(String str) {
        log.info(str + " ... ");
        Timing.startTime();
    }

    public static void endDoing() {
        long elapsed = System.nanoTime() - startTime;
        log.info("done [" + nf.format((double)elapsed / 1.0E9) + " sec].");
    }

    public static void endDoing(String msg) {
        long elapsed = System.nanoTime() - startTime;
        log.info(msg + " done [" + nf.format((double)elapsed / 1.0E9) + " sec].");
    }

    public static long tick() {
        long elapsed = (System.nanoTime() - startTime) / 1000000L;
        Timing.startTime();
        return elapsed;
    }

    public static long tick(String str, PrintStream stream) {
        long elapsed = Timing.tick();
        stream.println(str + " Time elapsed: " + elapsed + " ms");
        return elapsed;
    }

    public static long tick(String str) {
        return Timing.tick(str, System.err);
    }

    public String toString() {
        return "Timing[start=" + startTime + ']';
    }
}

