/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;

public class CacheMap<K, V>
extends LinkedHashMap<K, V> {
    private static final Redwood.RedwoodChannels log = Redwood.channels(CacheMap.class);
    private static final long serialVersionUID = 1L;
    private String backingFile;
    private int CACHE_ENTRIES;
    private int entriesSinceLastWritten;
    private int frequencyToWrite;
    private int hits;
    private int misses;
    private int puts;

    public CacheMap(int numEntries, float loadFactor, boolean accessOrder, String backingFile) {
        super((int)Math.ceil((float)(numEntries + 1) / loadFactor), loadFactor, accessOrder);
        this.CACHE_ENTRIES = numEntries;
        this.backingFile = backingFile;
        this.entriesSinceLastWritten = 0;
        this.frequencyToWrite = numEntries / 128 + 1;
        this.puts = 0;
        this.misses = 0;
        this.hits = 0;
    }

    public CacheMap(int numEntries, float loadFactor, boolean accessOrder) {
        this(numEntries, loadFactor, accessOrder, null);
    }

    public CacheMap(int numEntries, float loadFactor) {
        this(numEntries, loadFactor, false, null);
    }

    public CacheMap(int numEntries) {
        this(numEntries, 0.75f, false, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <K, V> CacheMap<K, V> create(int numEntries, float loadFactor, boolean accessOrder, String file, boolean useFileParams) {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
            CacheMap c = (CacheMap)ErasureUtils.uncheckedCast(ois.readObject());
            log.info("Read cache from " + file + ", contains " + c.size() + " entries.  Backing file is " + c.backingFile);
            if (!useFileParams) {
                c.backingFile = file;
                c.puts = 0;
                c.misses = 0;
                c.hits = 0;
                c.CACHE_ENTRIES = numEntries;
            }
            CacheMap cacheMap = c;
            return cacheMap;
        }
        catch (FileNotFoundException ex) {
            log.info("Cache file " + file + " has not been created yet.  Making new one.");
            return new CacheMap<K, V>(numEntries, loadFactor, accessOrder, file);
        }
        catch (Exception ex) {
            log.info("Error reading cache file " + file + ".  Making a new cache and NOT backing to file.");
            return new CacheMap<K, V>(numEntries, loadFactor, accessOrder);
        }
    }

    public static <K, V> CacheMap<K, V> create(int numEntries, float loadFactor, String file, boolean useFileParams) {
        return CacheMap.create(numEntries, loadFactor, false, file, useFileParams);
    }

    public static <K, V> CacheMap<K, V> create(int numEntries, String file, boolean useFileParams) {
        return CacheMap.create(numEntries, 0.75f, false, file, useFileParams);
    }

    public static <K, V> CacheMap<K, V> create(String file, boolean useFileParams) {
        return CacheMap.create(1000, 0.75f, false, file, useFileParams);
    }

    public void write() {
        this.entriesSinceLastWritten = 0;
        if (this.frequencyToWrite < this.CACHE_ENTRIES / 4) {
            this.frequencyToWrite *= 2;
        }
        if (this.backingFile == null) {
            return;
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.backingFile));){
            log.info("Writing cache (size: " + this.size() + ") to " + this.backingFile);
            oos.writeObject(this);
        }
        catch (Exception ex) {
            log.info("Error writing cache to file: " + this.backingFile + '!');
            log.info(ex);
        }
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.CACHE_ENTRIES;
    }

    @Override
    public V get(Object key) {
        Object result = super.get(key);
        if (result == null) {
            ++this.misses;
        } else {
            ++this.hits;
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        V result = super.put(key, value);
        ++this.puts;
        if (++this.entriesSinceLastWritten >= this.frequencyToWrite) {
            this.write();
        }
        return result;
    }

    public void printStats(PrintStream out2) {
        out2.println("cache stats: size: " + this.size() + ", hits: " + this.hits + ", misses: " + this.misses + ", puts: " + this.puts + ", hit % (using misses): " + (float)this.hits / (float)(this.hits + this.misses) + ", hit % (using puts): " + (float)this.hits / (float)(this.hits + this.puts));
    }
}

