/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic.pipeline;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class MWETreeVisitor
implements TreeVisitor {
    private static final Redwood.RedwoodChannels log = Redwood.channels(MWETreeVisitor.class);
    private static final boolean DEBUG = false;
    private final List<Pair<TregexPattern, TsurgeonPattern>> ops = MWETreeVisitor.loadOps();
    private static final String editStr = "@VP=vp < /PP-CLR/=pp\nrelabel vp MWV\nrelabel pp MWP\n\n";

    private static List<Pair<TregexPattern, TsurgeonPattern>> loadOps() {
        ArrayList<Pair<TregexPattern, TsurgeonPattern>> ops = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new StringReader(editStr));
            ArrayList<TsurgeonPattern> tsp = new ArrayList<TsurgeonPattern>();
            while ((line = br.readLine()) != null) {
                TregexPattern matchPattern = TregexPattern.compile(line);
                tsp.clear();
                while (MWETreeVisitor.continuing(line = br.readLine())) {
                    TsurgeonPattern p = Tsurgeon.parseOperation(line);
                    tsp.add(p);
                }
                if (tsp.isEmpty()) continue;
                TsurgeonPattern tp = Tsurgeon.collectOperations(tsp);
                ops.add(new Pair<TregexPattern, TsurgeonPattern>(matchPattern, tp));
            }
        }
        catch (IOException ioe) {
            log.warn(ioe);
        }
        return ops;
    }

    private static boolean continuing(String str) {
        return str != null && !str.matches("\\s*");
    }

    @Override
    public void visitTree(Tree t) {
        Tsurgeon.processPatternsOnTree(this.ops, t);
    }
}

