/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MapList<U, V> {
    protected Map<U, List<V>> map = Generics.newHashMap();

    public void add(U key, V val) {
        this.ensureList(key).add(val);
    }

    public void add(U key, Collection<V> vals) {
        this.ensureList(key).addAll(vals);
    }

    public int size(U key) {
        if (this.map.containsKey(key)) {
            return this.map.get(key).size();
        }
        return 0;
    }

    public boolean containsKey(U key) {
        return this.map.containsKey(key);
    }

    public Collection<U> keySet() {
        return this.map.keySet();
    }

    public V get(U key, int index) {
        List<V> list;
        if (this.map.containsKey(key) && index < (list = this.map.get(key)).size()) {
            return this.map.get(key).get(index);
        }
        return null;
    }

    protected List<V> ensureList(U key) {
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        ArrayList newList = new ArrayList();
        this.map.put(key, newList);
        return newList;
    }
}

