/*
 * Decompiled with CFR 0.152.
 */
package eu.dozd.mongo;

import eu.dozd.mongo.EntityInfo;
import eu.dozd.mongo.MongoMapper;
import eu.dozd.mongo.MongoMapperException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.IdGenerator;
import org.bson.codecs.ObjectIdGenerator;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.ObjectId;

class EntityCodec<T>
implements CollectibleCodec<T> {
    private final Class<T> clazz;
    private final EntityInfo info;
    private final IdGenerator idGenerator;
    private final DocumentCodec documentCodec;
    private final BsonTypeClassMap bsonTypeClassMap;
    private final CodecRegistry registry;

    public EntityCodec(Class<T> clazz, EntityInfo info) {
        this.clazz = clazz;
        this.info = info;
        this.idGenerator = (IdGenerator)Assertions.notNull((String)"idGenerator", (Object)new ObjectIdGenerator());
        this.registry = CodecRegistries.fromProviders(MongoMapper.getProviders());
        this.documentCodec = new DocumentCodec(this.registry, new BsonTypeClassMap());
        this.bsonTypeClassMap = new BsonTypeClassMap();
    }

    public T generateIdIfAbsentFromDocument(T t) {
        if (!this.documentHasId(t)) {
            this.info.setId(t, this.idGenerator.generate().toString());
        }
        return t;
    }

    public boolean documentHasId(T t) {
        if (this.info.getIdColumn() != null) {
            String id = this.info.getId(t);
            return id != null;
        }
        return false;
    }

    public BsonValue getDocumentId(T t) {
        String id = this.info.getId(t);
        return new BsonObjectId(new ObjectId(id));
    }

    public T decode(BsonReader bsonReader, DecoderContext decoderContext) {
        T t;
        Document document = new Document();
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = bsonReader.readName();
            if (this.info.isMappedReference(fieldName)) {
                document.put(fieldName, this.registry.get(this.info.getFieldType(fieldName)).decode(bsonReader, decoderContext));
                continue;
            }
            document.put(fieldName, this.readValue(bsonReader, decoderContext));
        }
        bsonReader.readEndDocument();
        try {
            t = this.clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new MongoMapperException("Cannot create instance of class " + this.clazz.getName(), e);
        }
        for (String field : this.info.getFields()) {
            if (field.equals(this.info.getIdColumn())) {
                this.info.setId(t, (String)document.get((Object)"_id"));
                continue;
            }
            Object o = document.get((Object)field);
            if (this.info.getFieldType(field).isEnum()) {
                this.info.setValue(t, field, Enum.valueOf(this.info.getFieldType(field), (String)o));
                continue;
            }
            this.info.setValue(t, field, o);
        }
        return t;
    }

    public void encode(BsonWriter bsonWriter, T t, EncoderContext encoderContext) {
        Document document = new Document();
        for (String field : this.info.getFields()) {
            if (field.equals(this.info.getIdColumn())) {
                if (!this.documentHasId(t)) continue;
                document.put("_id", (Object)this.info.getId(t));
                continue;
            }
            if (this.info.getFieldType(field).isEnum()) {
                document.put(field, (Object)((Enum)this.info.getValue(t, field)).name());
                continue;
            }
            document.put(field, this.info.getValue(t, field));
        }
        this.documentCodec.encode(bsonWriter, document, encoderContext);
    }

    public Class<T> getEncoderClass() {
        return this.clazz;
    }

    private Object readValue(BsonReader reader, DecoderContext decoderContext) {
        byte bsonSubType;
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        if (bsonType == BsonType.ARRAY) {
            return this.readList(reader, decoderContext);
        }
        if (bsonType == BsonType.BINARY && ((bsonSubType = reader.peekBinarySubType()) == BsonBinarySubType.UUID_STANDARD.getValue() || bsonSubType == BsonBinarySubType.UUID_LEGACY.getValue())) {
            return this.registry.get(UUID.class).decode(reader, decoderContext);
        }
        return this.registry.get(this.bsonTypeClassMap.get(bsonType)).decode(reader, decoderContext);
    }

    private List<Object> readList(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list.add(this.readValue(reader, decoderContext));
        }
        reader.readEndArray();
        return list;
    }
}

