/*
 * Decompiled with CFR 0.152.
 */
package eu.dozd.mongo;

import eu.dozd.mongo.MongoMapperException;
import eu.dozd.mongo.annotation.Entity;
import eu.dozd.mongo.annotation.Id;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class EntityInfo {
    private String idColumn;
    private final Map<String, PropertyDescriptor> fields = new HashMap<String, PropertyDescriptor>();

    public EntityInfo(Class<?> klass) {
        PropertyDescriptor[] descriptors;
        try {
            descriptors = Introspector.getBeanInfo(klass).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        boolean idFound = false;
        block2: for (PropertyDescriptor pd : descriptors) {
            Annotation[] declaredAnnotations;
            if (pd.getReadMethod() == null || "class".equals(pd.getName())) continue;
            for (Annotation annotation : declaredAnnotations = pd.getReadMethod().getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(Id.class)) continue;
                this.setIdColumn(pd.getDisplayName());
                idFound = true;
                continue block2;
            }
        }
        if (!idFound && !this.findFieldAnnotation(klass)) {
            throw new MongoMapperException("No ID field defined on class " + klass.getCanonicalName());
        }
        this.setDescriptors(Arrays.asList(descriptors));
    }

    public Set<String> getFields() {
        return Collections.unmodifiableSet(this.fields.keySet());
    }

    public String getIdColumn() {
        return this.idColumn;
    }

    public boolean isMappedReference(String field) {
        if (!this.fields.containsKey(field)) {
            return false;
        }
        PropertyDescriptor pd = this.getField(field);
        return pd.getPropertyType().isAnnotationPresent(Entity.class);
    }

    public Class<?> getFieldType(String field) {
        return this.getField(field).getPropertyType();
    }

    public void setValue(Object o, String field, Object v) {
        Method writeMethod = this.getField(field).getWriteMethod();
        if (writeMethod == null) {
            throw new MongoMapperException("Setter for property [" + field + "] in class [" + o.getClass().getCanonicalName() + "] not found.");
        }
        try {
            writeMethod.invoke(o, v);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MongoMapperException("Cannot set value for property [" + field + "] in class [" + o.getClass().getCanonicalName() + "].", e);
        }
    }

    public Object getValue(Object o, String field) {
        Method readMethod = this.getField(field).getReadMethod();
        try {
            return readMethod.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MongoMapperException("Cannot get value from property [" + field + "] in class [" + o.getClass().getCanonicalName() + "].", e);
        }
    }

    public void setId(Object o, String id) {
        this.setValue(o, this.idColumn, id);
    }

    public String getId(Object o) {
        return (String)this.getValue(o, this.idColumn);
    }

    private boolean findFieldAnnotation(Class<?> klass) {
        for (Field field : klass.getDeclaredFields()) {
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(Id.class)) continue;
                this.setIdColumn(field.getName());
                return true;
            }
        }
        return false;
    }

    private PropertyDescriptor getField(String field) {
        PropertyDescriptor descriptor = this.fields.get(field);
        if (descriptor == null) {
            throw new MongoMapperException("Cannot find definition for property [" + field + "]. Are you missing getter?");
        }
        return descriptor;
    }

    private void setIdColumn(String idColumn) {
        this.idColumn = idColumn;
    }

    private void setDescriptors(List<PropertyDescriptor> descriptors) {
        for (PropertyDescriptor descriptor : descriptors) {
            if ("class".equals(descriptor.getName())) continue;
            this.fields.put(descriptor.getDisplayName(), descriptor);
        }
    }
}

