/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ocsp;

import eu.emi.security.authn.x509.OCSPCheckingMode;
import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPResult;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPVerifier;
import eu.emi.security.authn.x509.helpers.pkipath.SimpleValidationErrorException;
import eu.emi.security.authn.x509.helpers.revocation.RevocationChecker;
import eu.emi.security.authn.x509.helpers.revocation.RevocationStatus;
import java.security.cert.X509Certificate;

public class OCSPRevocationChecker
implements RevocationChecker {
    private OCSPVerifier verifier;
    private OCSPCheckingMode checkingMode;

    public OCSPRevocationChecker(OCSPVerifier verifier, OCSPCheckingMode checkingMode) {
        this.verifier = verifier;
        this.checkingMode = checkingMode;
    }

    @Override
    public RevocationStatus checkRevocation(X509Certificate certitifcate, X509Certificate issuer) throws SimpleValidationErrorException {
        OCSPResult status;
        if (this.checkingMode == OCSPCheckingMode.IGNORE) {
            return RevocationStatus.unknown;
        }
        try {
            status = this.verifier.verify(certitifcate, issuer);
        }
        catch (SimpleValidationErrorException e) {
            if (this.checkingMode == OCSPCheckingMode.REQUIRE) {
                throw e;
            }
            return RevocationStatus.unknown;
        }
        if (status.getStatus() == OCSPResult.Status.revoked) {
            throw new SimpleValidationErrorException(ValidationErrorCode.ocspCertRevoked, status.getRevocationTime(), status.getRevocationReason());
        }
        if (status.getStatus() == OCSPResult.Status.good) {
            return RevocationStatus.verified;
        }
        return RevocationStatus.unknown;
    }
}

