/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.commons.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import eu.trentorise.opendata.commons.Dict;
import eu.trentorise.opendata.commons.LocalizedString;
import eu.trentorise.opendata.commons.PeriodOfTime;
import eu.trentorise.opendata.commons.SemVersion;
import eu.trentorise.opendata.commons.TodConfig;
import eu.trentorise.opendata.commons.validation.Ref;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Logger;

public final class TodCommonsModule
extends SimpleModule {
    private static final Logger LOG = Logger.getLogger(TodCommonsModule.class.getName());
    private static final long serialVersionUID = 1L;

    public TodCommonsModule() {
        super("tod-commons-jackson", TodCommonsModule.readJacksonVersion(TodCommonsModule.class));
        this.addSerializer(Dict.class, (JsonSerializer)new StdSerializer<Dict>(Dict.class){

            public void serialize(Dict value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeObject((Object)value.asMultimap());
            }
        });
        this.addDeserializer(Dict.class, (JsonDeserializer)new StdDeserializer<Dict>(Dict.class){

            public Dict deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                TypeReference<ImmutableListMultimap<Locale, String>> ref = new TypeReference<ImmutableListMultimap<Locale, String>>(){};
                return Dict.of((Multimap)((ImmutableListMultimap)jp.readValueAs((TypeReference)ref)));
            }
        });
        this.addDeserializer(Locale.class, (JsonDeserializer)new LocaleDeserializer());
        this.setMixInAnnotation(LocalizedString.class, JacksonLocalizedString.class);
        this.setMixInAnnotation(Ref.class, JacksonRef.class);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public static Version readJacksonVersion(Class clazz) {
        SemVersion semver = SemVersion.of((String)TodConfig.of((Class)clazz).getBuildInfo().getVersion());
        return new Version(semver.getMajor(), semver.getMinor(), semver.getPatch(), semver.getPreReleaseVersion(), "eu.trentorise.opendata.commons.jackson", "tod-commons-jackson");
    }

    public static void registerModulesInto(ObjectMapper om) {
        om.registerModule((Module)new GuavaModule());
        om.registerModule((Module)new TodCommonsModule());
    }

    public static class LocaleDeserializer
    extends StdDeserializer<Locale> {
        public LocaleDeserializer() {
            super(Locale.class);
        }

        public LocaleDeserializer(Class<Locale> vc) {
            super(vc);
        }

        public Locale deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NULL) {
                return Locale.ROOT;
            }
            if (t == JsonToken.VALUE_STRING) {
                String text = jp.getText();
                return Locale.forLanguageTag(text);
            }
            throw new IOException("Error while parsing Locale! Unrecognized JSON token: " + t.toString());
        }
    }

    private static abstract class JacksonRef {
        private JacksonRef() {
        }

        @JsonCreator
        public static Ref of(@JsonProperty(value="documentId") String documentId, @JsonProperty(value="physicalRow") int physicalRow, @JsonProperty(value="physicalColumn") int physicalColumn, @JsonProperty(value="jsonPath") String jsonPath) {
            return null;
        }
    }

    private static abstract class JacksonLocalizedString {
        private JacksonLocalizedString() {
        }

        @JsonCreator
        public static LocalizedString of(@JsonProperty(value="locale") Locale locale, @JsonProperty(value="string") String string) {
            return null;
        }
    }

    private static abstract class JacksonPeriodOfTime {
        private JacksonPeriodOfTime() {
        }

        @JsonCreator
        public static PeriodOfTime of(@JsonProperty(value="startDate") String startDate, @JsonProperty(value="endDate") String endDate, @JsonProperty(value="rawString") String rawString) {
            return null;
        }
    }
}

