/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.profiler;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import fr.jcgay.maven.profiler.reporting.CompositeReporter;
import fr.jcgay.maven.profiler.reporting.Reporter;
import fr.jcgay.maven.profiler.reporting.console.ConsoleReporter;
import fr.jcgay.maven.profiler.reporting.html.HtmlReporter;
import fr.jcgay.maven.profiler.reporting.json.JsonReporter;
import fr.jcgay.maven.profiler.sorting.Sorter;
import fr.jcgay.maven.profiler.sorting.execution.ByExecutionOrder;
import fr.jcgay.maven.profiler.sorting.time.ByExecutionTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Configuration {
    private static final String PROFILE = "profile";
    private static final String PROFILE_FORMAT = "profileFormat";
    private static final String DISABLE_TIME_SORTING = "disableTimeSorting";
    private static final String DISABLE_PARAMETERS_REPORT = "hideParameters";
    private static final Function<String, Reporter> reporters = Functions.compose((Function)Functions.forMap((Map)ImmutableMap.builder().put((Object)"html", (Object)new HtmlReporter()).put((Object)"json", (Object)new JsonReporter()).put((Object)"console", (Object)new ConsoleReporter()).build()), String::toLowerCase);
    private final boolean isProfiling;
    private final String profileName;
    private final Reporter reporter;
    private final Sorter sorter;
    private final boolean shouldPrintParameters;

    public Configuration(boolean isProfiling, String profileName, Reporter reporter, Sorter sorter, boolean shouldPrintParameters) {
        this.isProfiling = isProfiling;
        this.profileName = (String)Preconditions.checkNotNull((Object)profileName);
        this.reporter = reporter;
        this.sorter = sorter;
        this.shouldPrintParameters = shouldPrintParameters;
    }

    public static Configuration read() {
        return new Configuration(Configuration.isActive(), Configuration.getProfileName(), Configuration.chooseReporter(), Configuration.chooseSorter(), Configuration.hasParametersReportEnabled());
    }

    public boolean isProfiling() {
        return this.isProfiling;
    }

    public String profileName() {
        return this.profileName;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public Sorter sorter() {
        return this.sorter;
    }

    public boolean shouldPrintParameters() {
        return this.shouldPrintParameters;
    }

    private static boolean hasParametersReportEnabled() {
        return Boolean.parseBoolean(System.getProperty(DISABLE_PARAMETERS_REPORT, "false"));
    }

    private static Sorter chooseSorter() {
        if (Configuration.isSortingActive()) {
            return new ByExecutionTime();
        }
        return new ByExecutionOrder();
    }

    private static Reporter chooseReporter() {
        List<String> formats = Arrays.asList(System.getProperty(PROFILE_FORMAT, "html").split(","));
        return new CompositeReporter(Collections2.transform(formats, reporters));
    }

    private static boolean isSortingActive() {
        String parameter = System.getProperty(DISABLE_TIME_SORTING);
        return parameter == null || "false".equalsIgnoreCase(parameter);
    }

    private static String getProfileName() {
        String profile = System.getProperty(PROFILE, "");
        if (profile.equals("true")) {
            return "";
        }
        return profile;
    }

    private static boolean isActive() {
        String parameter = System.getProperty(PROFILE);
        return parameter != null && !"false".equalsIgnoreCase(parameter);
    }
}

