/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.timer;

import java.util.TimerTask;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.timer.PersistenceException;
import org.apache.geronimo.timer.ThreadPooledTimer;
import org.apache.geronimo.timer.WorkInfo;

public class ExecutorFeedingTimerTask
extends TimerTask {
    private static final Log log = LogFactory.getLog((Class)ExecutorFeedingTimerTask.class);
    private final WorkInfo workInfo;
    private final ThreadPooledTimer threadPooledTimer;
    boolean cancelled = false;

    public ExecutorFeedingTimerTask(WorkInfo workInfo, ThreadPooledTimer threadPooledTimer) {
        this.workInfo = workInfo;
        this.threadPooledTimer = threadPooledTimer;
    }

    public void run() {
        try {
            this.threadPooledTimer.getExecutor().execute(this.workInfo.getExecutorTask());
        }
        catch (InterruptedException e) {
            log.warn((Object)e);
        }
    }

    public boolean cancel() {
        this.threadPooledTimer.removeWorkInfo(this.workInfo);
        try {
            this.threadPooledTimer.registerSynchronization(new CancelSynchronization(this));
        }
        catch (RollbackException e) {
            log.info((Object)e);
            throw (IllegalStateException)new IllegalStateException("RollbackException when trying to register Cancel Synchronization").initCause(e);
        }
        catch (SystemException e) {
            log.info((Object)e);
            throw (IllegalStateException)new IllegalStateException("SystemException when trying to register Cancel Synchronization").initCause(e);
        }
        this.cancelled = true;
        return super.cancel();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void doCancel() {
        try {
            this.threadPooledTimer.getWorkerPersistence().cancel(this.workInfo.getId());
        }
        catch (PersistenceException e) {
            log.warn((Object)e);
        }
    }

    private void rollbackCancel() {
        this.threadPooledTimer.addWorkInfo(this.workInfo);
        if (this.workInfo.isOneTime()) {
            this.threadPooledTimer.getTimer().schedule((TimerTask)new ExecutorFeedingTimerTask(this.workInfo, this.threadPooledTimer), this.workInfo.getTime());
        } else if (this.workInfo.getAtFixedRate()) {
            this.threadPooledTimer.getTimer().scheduleAtFixedRate((TimerTask)new ExecutorFeedingTimerTask(this.workInfo, this.threadPooledTimer), this.workInfo.getTime(), (long)this.workInfo.getPeriod());
        } else {
            this.threadPooledTimer.getTimer().schedule((TimerTask)new ExecutorFeedingTimerTask(this.workInfo, this.threadPooledTimer), this.workInfo.getTime(), (long)this.workInfo.getPeriod());
        }
    }

    private static class CancelSynchronization
    implements Synchronization {
        private final ExecutorFeedingTimerTask worker;

        public CancelSynchronization(ExecutorFeedingTimerTask worker) {
            this.worker = worker;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                this.worker.doCancel();
            } else if (status == 4) {
                this.worker.rollbackCancel();
            }
        }
    }
}

