/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.timer;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.timer.ExecutorFeedingTimerTask;
import org.apache.geronimo.timer.ExecutorTask;
import org.apache.geronimo.timer.ExecutorTaskFactory;
import org.apache.geronimo.timer.PersistenceException;
import org.apache.geronimo.timer.PersistentTimer;
import org.apache.geronimo.timer.Playback;
import org.apache.geronimo.timer.UserTaskFactory;
import org.apache.geronimo.timer.WorkInfo;
import org.apache.geronimo.timer.WorkerPersistence;
import org.apache.geronimo.transaction.context.TransactionContext;
import org.apache.geronimo.transaction.context.TransactionContextManager;

public class ThreadPooledTimer
implements PersistentTimer,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)ThreadPooledTimer.class);
    private final ExecutorTaskFactory executorTaskFactory;
    private final WorkerPersistence workerPersistence;
    private final Executor executor;
    private final TransactionContextManager transactionContextManager;
    private Timer delegate;
    private final Map idToWorkInfoMap = Collections.synchronizedMap(new HashMap());

    public ThreadPooledTimer() {
        this(null, null, null, null);
    }

    public ThreadPooledTimer(ExecutorTaskFactory executorTaskFactory, WorkerPersistence workerPersistence, Executor executor, TransactionContextManager transactionContextManager) {
        this.executorTaskFactory = executorTaskFactory;
        this.workerPersistence = workerPersistence;
        this.executor = executor;
        this.transactionContextManager = transactionContextManager;
    }

    public void doStart() throws Exception {
        this.delegate = new Timer(true);
    }

    public void doStop() {
        if (this.delegate != null) {
            this.delegate.cancel();
            this.delegate = null;
        }
    }

    public void doFail() {
        this.doStop();
    }

    public WorkInfo schedule(UserTaskFactory userTaskFactory, String key, Object userId, Object userInfo, long delay) throws PersistenceException, RollbackException, SystemException {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay: " + delay);
        }
        Date time = new Date(System.currentTimeMillis() + delay);
        return this.schedule(key, userTaskFactory, userId, userInfo, time);
    }

    public WorkInfo schedule(String key, UserTaskFactory userTaskFactory, Object userId, Object userInfo, Date time) throws PersistenceException, RollbackException, SystemException {
        if (time == null) {
            throw new IllegalArgumentException("No time supplied");
        }
        if (time.getTime() < 0L) {
            throw new IllegalArgumentException("Negative time: " + time.getTime());
        }
        WorkInfo worker = this.createWorker(key, userTaskFactory, this.executorTaskFactory, userId, userInfo, time, null, false);
        this.registerSynchronization(new ScheduleSynchronization(worker.getExecutorFeedingTimerTask(), time));
        this.addWorkInfo(worker);
        return worker;
    }

    public WorkInfo schedule(String key, UserTaskFactory userTaskFactory, Object userInfo, long delay, long period, Object userId) throws PersistenceException, RollbackException, SystemException {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay: " + delay);
        }
        if (period < 0L) {
            throw new IllegalArgumentException("Negative period: " + period);
        }
        Date time = new Date(System.currentTimeMillis() + delay);
        return this.schedule(key, userTaskFactory, userId, userInfo, time, period);
    }

    public WorkInfo schedule(String key, UserTaskFactory userTaskFactory, Object userId, Object userInfo, Date firstTime, long period) throws PersistenceException, RollbackException, SystemException {
        if (firstTime == null) {
            throw new IllegalArgumentException("No time supplied");
        }
        if (firstTime.getTime() < 0L) {
            throw new IllegalArgumentException("Negative time: " + firstTime.getTime());
        }
        if (period < 0L) {
            throw new IllegalArgumentException("Negative period: " + period);
        }
        WorkInfo worker = this.createWorker(key, userTaskFactory, this.executorTaskFactory, userId, userInfo, firstTime, new Long(period), false);
        this.registerSynchronization(new ScheduleRepeatedSynchronization(worker.getExecutorFeedingTimerTask(), firstTime, period));
        this.addWorkInfo(worker);
        return worker;
    }

    public WorkInfo scheduleAtFixedRate(String key, UserTaskFactory userTaskFactory, Object userId, Object userInfo, long delay, long period) throws PersistenceException, RollbackException, SystemException {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay: " + delay);
        }
        if (period < 0L) {
            throw new IllegalArgumentException("Negative period: " + period);
        }
        Date time = new Date(System.currentTimeMillis() + delay);
        return this.scheduleAtFixedRate(key, userTaskFactory, userId, userInfo, time, period);
    }

    public WorkInfo scheduleAtFixedRate(String key, UserTaskFactory userTaskFactory, Object userId, Object userInfo, Date firstTime, long period) throws PersistenceException, RollbackException, SystemException {
        if (firstTime == null) {
            throw new IllegalArgumentException("No time supplied");
        }
        if (firstTime.getTime() < 0L) {
            throw new IllegalArgumentException("Negative time: " + firstTime.getTime());
        }
        if (period < 0L) {
            throw new IllegalArgumentException("Negative period: " + period);
        }
        WorkInfo worker = this.createWorker(key, userTaskFactory, this.executorTaskFactory, userId, userInfo, firstTime, new Long(period), true);
        this.registerSynchronization(new ScheduleAtFixedRateSynchronization(worker.getExecutorFeedingTimerTask(), firstTime, period));
        this.addWorkInfo(worker);
        return worker;
    }

    public Collection playback(String key, UserTaskFactory userTaskFactory) throws PersistenceException {
        PlaybackImpl playback = new PlaybackImpl(userTaskFactory);
        this.workerPersistence.playback(key, playback);
        return playback.getWorkInfos();
    }

    public Collection getIdsByKey(String key, Object userId) throws PersistenceException {
        return this.workerPersistence.getIdsByKey(key, userId);
    }

    public WorkInfo getWorkInfo(Long id) {
        return (WorkInfo)this.idToWorkInfoMap.get(id);
    }

    public void cancelTimerTasks(Collection ids) {
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            Long idLong = (Long)iterator.next();
            WorkInfo workInfo = this.getWorkInfo(idLong);
            if (workInfo == null) continue;
            ExecutorFeedingTimerTask timerTask = workInfo.getExecutorFeedingTimerTask();
            ((TimerTask)timerTask).cancel();
        }
    }

    void addWorkInfo(WorkInfo worker) {
        this.idToWorkInfoMap.put(new Long(worker.getId()), worker);
    }

    void removeWorkInfo(WorkInfo workInfo) {
        this.idToWorkInfoMap.remove(new Long(workInfo.getId()));
    }

    void workPerformed(WorkInfo workInfo) throws PersistenceException {
        if (workInfo.isOneTime()) {
            this.workerPersistence.cancel(workInfo.getId());
        } else if (workInfo.getAtFixedRate()) {
            this.workerPersistence.fixedRateWorkPerformed(workInfo.getId());
            workInfo.nextTime();
        } else {
            workInfo.nextInterval();
            this.workerPersistence.intervalWorkPerformed(workInfo.getId(), workInfo.getPeriod());
        }
    }

    Timer getTimer() {
        if (this.delegate == null) {
            throw new IllegalStateException("Timer is stopped");
        }
        return this.delegate;
    }

    WorkerPersistence getWorkerPersistence() {
        return this.workerPersistence;
    }

    Executor getExecutor() {
        return this.executor;
    }

    private WorkInfo createWorker(String key, UserTaskFactory userTaskFactory, ExecutorTaskFactory executorTaskFactory, Object userId, Object userInfo, Date time, Long period, boolean atFixedRate) throws PersistenceException {
        if (time == null) {
            throw new IllegalArgumentException("Null initial time");
        }
        WorkInfo workInfo = new WorkInfo(key, userId, userInfo, time, period, atFixedRate);
        this.workerPersistence.save(workInfo);
        Runnable userTask = userTaskFactory.newTask(workInfo.getId());
        ExecutorTask executorTask = executorTaskFactory.createExecutorTask(userTask, workInfo, this);
        ExecutorFeedingTimerTask worker = new ExecutorFeedingTimerTask(workInfo, this);
        workInfo.initialize(worker, executorTask);
        return workInfo;
    }

    void registerSynchronization(Synchronization sync) throws RollbackException, SystemException {
        TransactionContext transactionContext = this.transactionContextManager.getContext();
        if (transactionContext != null && transactionContext.isInheritable() && transactionContext.isActive()) {
            transactionContext.registerSynchronization(sync);
        } else {
            sync.beforeCompletion();
            sync.afterCompletion(3);
        }
    }

    private class PlaybackImpl
    implements Playback {
        private final UserTaskFactory userTaskFactory;
        private final Collection workInfos = new ArrayList();

        public PlaybackImpl(UserTaskFactory userTaskFactory) {
            this.userTaskFactory = userTaskFactory;
        }

        public void schedule(WorkInfo workInfo) {
            Runnable userTask = this.userTaskFactory.newTask(workInfo.getId());
            ExecutorTask executorTask = ThreadPooledTimer.this.executorTaskFactory.createExecutorTask(userTask, workInfo, ThreadPooledTimer.this);
            ExecutorFeedingTimerTask worker = new ExecutorFeedingTimerTask(workInfo, ThreadPooledTimer.this);
            workInfo.initialize(worker, executorTask);
            if (workInfo.getPeriod() == null) {
                ThreadPooledTimer.this.getTimer().schedule((TimerTask)worker, workInfo.getTime());
            } else if (!workInfo.getAtFixedRate()) {
                ThreadPooledTimer.this.getTimer().schedule((TimerTask)worker, workInfo.getTime(), (long)workInfo.getPeriod());
            } else {
                ThreadPooledTimer.this.getTimer().scheduleAtFixedRate((TimerTask)worker, workInfo.getTime(), (long)workInfo.getPeriod());
            }
            ThreadPooledTimer.this.addWorkInfo(workInfo);
            this.workInfos.add(workInfo);
        }

        public Collection getWorkInfos() {
            return this.workInfos;
        }
    }

    private class ScheduleAtFixedRateSynchronization
    implements Synchronization {
        private final ExecutorFeedingTimerTask worker;
        private final Date time;
        private final long period;

        public ScheduleAtFixedRateSynchronization(ExecutorFeedingTimerTask worker, Date time, long period) {
            this.worker = worker;
            this.time = time;
            this.period = period;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                if (this.worker.isCancelled()) {
                    log.trace((Object)"Worker is already cancelled, not scheduleAtFixedRate");
                    return;
                }
                try {
                    ThreadPooledTimer.this.getTimer().scheduleAtFixedRate((TimerTask)this.worker, this.time, this.period);
                }
                catch (Exception e) {
                    log.info((Object)("Couldn't scheduleAtFixedRate worker " + e.getMessage() + "at (now) " + System.currentTimeMillis() + " for " + this.time.getTime()));
                }
            }
        }
    }

    private class ScheduleRepeatedSynchronization
    implements Synchronization {
        private final ExecutorFeedingTimerTask worker;
        private final Date time;
        private final long period;

        public ScheduleRepeatedSynchronization(ExecutorFeedingTimerTask worker, Date time, long period) {
            this.worker = worker;
            this.time = time;
            this.period = period;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                if (this.worker.isCancelled()) {
                    log.trace((Object)"Worker is already cancelled, not scheduling/period");
                    return;
                }
                try {
                    ThreadPooledTimer.this.getTimer().schedule((TimerTask)this.worker, this.time, this.period);
                }
                catch (Exception e) {
                    log.info((Object)("Couldn't schedule/period worker " + e.getMessage() + "at (now) " + System.currentTimeMillis() + " for " + this.time.getTime()));
                }
            }
        }
    }

    private class ScheduleSynchronization
    implements Synchronization {
        private final ExecutorFeedingTimerTask worker;
        private final Date time;

        public ScheduleSynchronization(ExecutorFeedingTimerTask worker, Date time) {
            this.worker = worker;
            this.time = time;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                if (this.worker.isCancelled()) {
                    log.trace((Object)"Worker is already cancelled, not scheduling");
                    return;
                }
                try {
                    ThreadPooledTimer.this.getTimer().schedule((TimerTask)this.worker, this.time);
                }
                catch (IllegalStateException e) {
                    log.info((Object)("Couldn't schedule worker " + e.getMessage() + "at (now) " + System.currentTimeMillis() + " for " + this.time.getTime()));
                }
            }
        }
    }
}

