/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8RuntimeException;
import com.eclipsesource.v8.utils.V8ObjectUtils;
import guru.nidi.graphviz.engine.AbstractJsGraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GraphvizV8Engine
extends AbstractJsGraphvizEngine {
    private static final Pattern ABORT = Pattern.compile("^undefined:\\d+: abort");
    private static final Pattern ERROR = Pattern.compile("^undefined:\\d+: (.*?)\n");
    private V8 v8;
    private V8Array messages;

    public GraphvizV8Engine() {
        super(true);
    }

    @Override
    public void release() {
        this.messages.release();
        this.v8.release(true);
    }

    @Override
    protected void doInit() throws Exception {
        this.v8 = V8.createV8Runtime();
        this.v8.executeVoidScript(this.jsInitEnv());
        this.messages = this.v8.getArray("$$prints");
        this.v8.executeVoidScript(this.jsVizCode("1.8.0"));
    }

    @Override
    protected String jsExecute(String call) {
        try {
            return this.v8.executeStringScript(call);
        }
        catch (V8RuntimeException e) {
            if (ABORT.matcher(e.getMessage()).find()) {
                throw new GraphvizException(IntStream.range(0, this.messages.length()).mapToObj(i -> V8ObjectUtils.getValue((V8Array)this.messages, (int)i).toString()).collect(Collectors.joining("\n")));
            }
            Matcher em = ERROR.matcher(e.getMessage());
            if (em.find()) {
                throw new GraphvizException(em.group(1));
            }
            throw new GraphvizException("Problem executing graphviz", e);
        }
    }
}

