/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.Engine;
import guru.nidi.graphviz.engine.Format;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Options {
    private static final Pattern FORMAT = Pattern.compile("format:'(.*?)'");
    private static final Pattern ENGINE = Pattern.compile("engine:'(.*?)'");
    private static final Pattern MEMORY = Pattern.compile("totalMemory:'(.*?)'");
    final Engine engine;
    final Format format;
    final Integer totalMemory;

    private Options(Engine engine, Format format, Integer totalMemory) {
        this.engine = engine;
        this.format = format;
        this.totalMemory = totalMemory;
    }

    public static Options create() {
        return new Options(Engine.DOT, null, null);
    }

    public static Options fromJson(String json) {
        Matcher format = FORMAT.matcher(json);
        format.find();
        Matcher engine = ENGINE.matcher(json);
        engine.find();
        Matcher memory = MEMORY.matcher(json);
        boolean hasMemory = memory.find();
        return new Options(Engine.valueOf(engine.group(1)), Format.valueOf(format.group(1)), hasMemory ? Integer.valueOf(Integer.parseInt(memory.group(1))) : null);
    }

    public Options engine(Engine engine) {
        return new Options(engine, this.format, this.totalMemory);
    }

    public Options format(Format format) {
        return new Options(this.engine, format, this.totalMemory);
    }

    public Options totalMemory(Integer totalMemory) {
        return new Options(this.engine, this.format, totalMemory);
    }

    public String toJson(boolean raw) {
        String form = "format:'" + (raw ? this.format : this.format.vizName) + "'";
        String eng = ",engine:'" + (raw ? this.engine : this.engine.toString().toLowerCase()) + "'";
        String mem = this.totalMemory == null ? "" : ",totalMemory:'" + this.totalMemory + "'";
        return "{" + form + eng + mem + "}";
    }
}

