/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.MutableAttributed;
import guru.nidi.graphviz.attribute.SimpleMutableAttributed;
import guru.nidi.graphviz.model.ImmutableNode;
import guru.nidi.graphviz.model.Label;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.Callable;

public final class CreationContext {
    private static final ThreadLocal<Stack<CreationContext>> CONTEXT = ThreadLocal.withInitial(Stack::new);
    private final Map<Label, ImmutableNode> immutableNodes = new HashMap<Label, ImmutableNode>();
    private final Map<Label, MutableNode> mutableNodes = new HashMap<Label, MutableNode>();
    private final MutableAttributed<CreationContext> nodeAttributes = new SimpleMutableAttributed<CreationContext>(this);
    private final MutableAttributed<CreationContext> linkAttributes = new SimpleMutableAttributed<CreationContext>(this);
    private final MutableAttributed<CreationContext> graphAttributes = new SimpleMutableAttributed<CreationContext>(this);

    private CreationContext() {
    }

    public static <T> T use(Callable<T> actions) {
        CreationContext.begin();
        try {
            T t = actions.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            CreationContext.end();
        }
    }

    public static Optional<CreationContext> current() {
        Stack<CreationContext> cs = CONTEXT.get();
        return cs.empty() ? Optional.empty() : Optional.of(cs.peek());
    }

    public static CreationContext begin() {
        CreationContext ctx = new CreationContext();
        CONTEXT.get().push(ctx);
        return ctx;
    }

    public static void end() {
        Stack<CreationContext> cs = CONTEXT.get();
        if (!cs.empty()) {
            cs.pop();
        }
    }

    public MutableAttributed<CreationContext> nodes() {
        return this.nodeAttributes;
    }

    public MutableAttributed<CreationContext> links() {
        return this.linkAttributes;
    }

    public MutableAttributed<CreationContext> graphs() {
        return this.graphAttributes;
    }

    Node immutableNode(Label label) {
        return this.immutableNodes.computeIfAbsent(label, ImmutableNode::new).with((Attributes)this.nodeAttributes);
    }

    MutableNode mutableNode(Label label) {
        return this.mutableNodes.computeIfAbsent(label, l -> new MutableNode().setLabel((Label)l)).add((Attributes)this.nodeAttributes);
    }
}

