/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.MapAttributes;

public final class Label
implements Attributes {
    final String value;
    final boolean html;

    private Label(String value, boolean html) {
        this.value = value;
        this.html = html;
    }

    public static Label of(String value) {
        return new Label(value, false);
    }

    public static Label html(String value) {
        return new Label(value, true);
    }

    public boolean isEmptyLabel() {
        return this.value.length() == 0;
    }

    public String serialized() {
        return this.html ? "<" + this.value + ">" : "\"" + this.value.replace("\"", "\\\"").replace("\n", "\\n") + "\"";
    }

    @Override
    public Attributes applyTo(MapAttributes attributes) {
        attributes.add("label", this);
        return attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Label label = (Label)o;
        return !(this.value == null ? label.value != null : !this.value.equals(label.value));
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return this.value;
    }
}

