/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.parse;

import guru.nidi.graphviz.attribute.Attributed;
import guru.nidi.graphviz.attribute.MutableAttributed;
import guru.nidi.graphviz.model.Compass;
import guru.nidi.graphviz.model.CreationContext;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Label;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableLinkSource;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.MutableNodePoint;
import guru.nidi.graphviz.parse.Lexer;
import guru.nidi.graphviz.parse.ParserException;
import guru.nidi.graphviz.parse.Token;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Parser {
    private final Lexer lexer;
    private Token token;

    public static MutableGraph read(File file) throws IOException {
        return Parser.read(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), file.getName());
    }

    public static MutableGraph read(InputStream is) throws IOException {
        return Parser.read(new InputStreamReader(is, StandardCharsets.UTF_8), "<input stream>");
    }

    public static MutableGraph read(String dot) throws IOException {
        return Parser.read(new StringReader(dot), "<string>");
    }

    public static MutableGraph read(Reader dot, String name) throws IOException {
        return new Parser(new Lexer(dot, name)).parse();
    }

    private Parser(Lexer lexer) throws IOException {
        this.lexer = lexer;
        this.nextToken();
    }

    private MutableGraph parse() throws IOException {
        return CreationContext.use(() -> {
            MutableGraph graph = new MutableGraph();
            if (this.token.type == 9) {
                graph.setStrict(true);
                this.nextToken();
            }
            if (this.token.type == 11) {
                graph.setDirected(true);
            } else if (this.token.type != 10) {
                this.fail("'graph' or 'digraph' expected");
            }
            this.nextToken();
            if (this.token.type == 16) {
                graph.setLabel(this.label(this.token));
                this.nextToken();
            }
            this.statementList(graph);
            this.assertToken(0);
            return graph;
        });
    }

    private Label label(Token token) {
        return token.subtype == 4 ? Label.html(token.value) : Label.of(token.value);
    }

    private void statementList(MutableGraph graph) throws IOException {
        this.assertToken(3);
        while (this.statement(graph)) {
            if (this.token.type != 1) continue;
            this.nextToken();
        }
        this.assertToken(4);
    }

    private boolean statement(MutableGraph graph) throws IOException {
        Token base = this.token;
        switch (base.type) {
            case 16: {
                this.nextToken();
                if (this.token.type == 5) {
                    this.applyMutableAttributes(graph.generalAttrs(), Arrays.asList(base, this.nextToken(16)));
                    this.nextToken();
                } else {
                    MutableNodePoint nodeId = this.nodeId(base);
                    if (this.token.type == 18 || this.token.type == 19) {
                        this.edgeStatement(graph, nodeId);
                    } else {
                        this.nodeStatement(graph, nodeId);
                    }
                }
                return true;
            }
            case 3: 
            case 14: {
                MutableGraph sub = this.subgraph(graph.isDirected());
                if (this.token.type == 18 || this.token.type == 19) {
                    this.edgeStatement(graph, sub);
                } else {
                    graph.add((LinkSource)sub);
                }
                return true;
            }
            case 10: 
            case 12: 
            case 13: {
                this.attributeStatement(graph);
                return true;
            }
        }
        return false;
    }

    private MutableGraph subgraph(boolean directed) throws IOException {
        return CreationContext.use(() -> {
            MutableGraph sub = new MutableGraph().setDirected(directed);
            if (this.token.type == 14) {
                this.nextToken();
                if (this.token.type == 16) {
                    sub.setLabel(this.label(this.token));
                    this.nextToken();
                }
            }
            this.statementList(sub);
            return sub;
        });
    }

    private void edgeStatement(MutableGraph graph, MutableLinkSource<? extends MutableLinkSource> linkSource) throws IOException {
        ArrayList<MutableLinkSource<? extends MutableLinkSource>> points = new ArrayList<MutableLinkSource<? extends MutableLinkSource>>();
        points.add(linkSource);
        do {
            if (graph.isDirected() && this.token.type == 18) {
                this.fail("-- used in digraph. Use -> instead.");
            }
            if (!graph.isDirected() && this.token.type == 19) {
                this.fail("-> used in graph. Use -- instead.");
            }
            this.nextToken();
            if (this.token.type == 16) {
                Token id = this.token;
                this.nextToken();
                points.add(this.nodeId(id));
                continue;
            }
            if (this.token.type != 14 && this.token.type != 3) continue;
            points.add(this.subgraph(graph.isDirected()));
        } while (this.token.type == 18 || this.token.type == 19);
        List<Token> attrs = this.token.type == 6 ? this.attributeList() : Collections.emptyList();
        for (int i = 0; i < points.size() - 1; ++i) {
            MutableLinkSource from = (MutableLinkSource)points.get(i);
            LinkTarget to = (LinkTarget)points.get(i + 1);
            graph.add((LinkSource)from.addLink(this.applyAttributes(Factory.between(from, to), attrs)));
        }
    }

    private Compass compass(String name) {
        return Compass.of(name).orElseThrow(() -> new ParserException(this.lexer.pos, "Invalid compass value '" + name + "'"));
    }

    private void nodeStatement(MutableGraph graph, MutableNodePoint nodeId) throws IOException {
        MutableNode node = Factory.mutNode(nodeId.node().label());
        if (this.token.type == 6) {
            this.applyMutableAttributes(node, this.attributeList());
        }
        graph.add((LinkSource)node);
    }

    private MutableNodePoint nodeId(Token base) throws IOException {
        MutableNodePoint node = new MutableNodePoint().setNode(Factory.mutNode(this.label(base)));
        if (this.token.type == 8) {
            String second = this.nextToken((int)16).value;
            this.nextToken();
            if (this.token.type == 8) {
                node.setRecord(second).setCompass(this.compass(this.nextToken((int)16).value));
                this.nextToken();
            } else {
                node.setCompass(this.compass(second));
            }
        }
        return node;
    }

    private void attributeStatement(MutableGraph graph) throws IOException {
        MutableAttributed<MutableGraph> target = this.attributes(graph, this.token);
        this.nextToken();
        this.applyMutableAttributes(target, this.attributeList());
    }

    private void applyMutableAttributes(MutableAttributed<?> attributed, List<Token> tokens) throws IOException {
        for (int i = 0; i < tokens.size(); i += 2) {
            attributed.add(tokens.get((int)i).value, tokens.get((int)(i + 1)).value);
        }
    }

    private <T extends Attributed<T>> T applyAttributes(T attributed, List<Token> tokens) throws IOException {
        Object res = attributed;
        for (int i = 0; i < tokens.size(); i += 2) {
            res = (Attributed)res.with(tokens.get((int)i).value, tokens.get((int)(i + 1)).value);
        }
        return res;
    }

    private MutableAttributed<MutableGraph> attributes(MutableGraph graph, Token token) {
        switch (token.type) {
            case 10: {
                return graph.graphAttrs();
            }
            case 12: {
                return graph.nodeAttrs();
            }
            case 13: {
                return graph.linkAttrs();
            }
        }
        return null;
    }

    private List<Token> attributeList() throws IOException {
        ArrayList<Token> res = new ArrayList<Token>();
        do {
            this.assertToken(6);
            if (this.token.type == 16) {
                res.addAll(this.attrListElement());
            }
            this.assertToken(7);
        } while (this.token.type == 6);
        return res;
    }

    private List<Token> attrListElement() throws IOException {
        ArrayList<Token> res = new ArrayList<Token>();
        do {
            res.add(this.token);
            this.nextToken(5);
            res.add(this.nextToken(16));
            this.nextToken();
            if (this.token.type != 1 && this.token.type != 2) continue;
            this.nextToken();
        } while (this.token.type == 16);
        return res;
    }

    private Token nextToken() throws IOException {
        this.token = this.lexer.token();
        return this.token;
    }

    private Token nextToken(int type) throws IOException {
        this.nextToken();
        this.checkToken(type);
        return this.token;
    }

    private Token assertToken(int type) throws IOException {
        this.checkToken(type);
        return this.nextToken();
    }

    private void checkToken(int type) {
        if (this.token.type != type) {
            this.fail("'" + Token.desc(type) + "' expected");
        }
    }

    private void fail(String msg) {
        throw new ParserException(this.lexer.pos, msg);
    }
}

