/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.EndLabel;
import guru.nidi.graphviz.attribute.MapAttributes;
import guru.nidi.graphviz.attribute.SimpleLabel;

public final class Label
extends SimpleLabel
implements Attributes {
    private final boolean external;
    private final boolean floating;
    private final boolean decorated;
    private final Justification just;
    private final Location loc;

    private Label(String value, boolean html, boolean external, boolean floating, boolean decorated, Justification just, Location loc) {
        super(value, html);
        this.external = external;
        this.floating = floating;
        this.decorated = decorated;
        this.just = just;
        this.loc = loc;
    }

    public static Label of(String value) {
        return new Label(value, false, false, false, false, null, null);
    }

    public static Label html(String value) {
        return new Label(value, true, false, false, false, null, null);
    }

    public EndLabel head() {
        return EndLabel.head(this, null, null);
    }

    public EndLabel head(double angle, double distance) {
        return EndLabel.head(this, angle, distance);
    }

    public EndLabel tail() {
        return EndLabel.tail(this, null, null);
    }

    public EndLabel tail(double angle, double distance) {
        return EndLabel.tail(this, angle, distance);
    }

    public Label external() {
        return new Label(this.value, this.html, true, this.floating, this.decorated, this.just, this.loc);
    }

    public Label floating() {
        return new Label(this.value, this.html, this.external, true, this.decorated, this.just, this.loc);
    }

    public Label decorated() {
        return new Label(this.value, this.html, this.external, this.floating, true, this.just, this.loc);
    }

    public Label justify(Justification just) {
        return new Label(this.value, this.html, this.external, this.floating, this.decorated, just, this.loc);
    }

    public Label locate(Location loc) {
        return new Label(this.value, this.html, this.external, this.floating, this.decorated, this.just, loc);
    }

    public boolean isExternal() {
        return this.external;
    }

    @Override
    public Attributes applyTo(MapAttributes attributes) {
        attributes.add(this.external ? "xlabel" : "label", this);
        if (this.floating) {
            attributes.add("labelfloat", true);
        }
        if (this.decorated) {
            attributes.add("decorate", true);
        }
        if (this.just == Justification.LEFT) {
            attributes.add("labeljust", "l");
        }
        if (this.just == Justification.RIGHT) {
            attributes.add("labeljust", "r");
        }
        if (this.loc == Location.TOP) {
            attributes.add("labelloc", "t");
        }
        if (this.loc == Location.BOTTOM) {
            attributes.add("labelloc", "b");
        }
        return attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Label label = (Label)o;
        return !(this.value == null ? label.value != null : !this.value.equals(label.value));
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public String toString() {
        return this.value;
    }

    public static enum Location {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum Justification {
        LEFT,
        MIDDLE,
        RIGHT;

    }
}

