/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.MutableAttributed;
import guru.nidi.graphviz.attribute.SimpleMutableAttributed;
import guru.nidi.graphviz.model.ImmutableNode;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.Callable;

public final class CreationContext {
    private static final ThreadLocal<Stack<CreationContext>> CONTEXT = ThreadLocal.withInitial(Stack::new);
    private final Map<Label, ImmutableNode> immutableNodes = new HashMap<Label, ImmutableNode>();
    private final Map<Label, MutableNode> mutableNodes = new HashMap<Label, MutableNode>();
    private final MutableAttributed<CreationContext> nodeAttributes = new SimpleMutableAttributed<CreationContext>(this);
    private final MutableAttributed<CreationContext> linkAttributes = new SimpleMutableAttributed<CreationContext>(this);
    private final MutableAttributed<CreationContext> graphAttributes = new SimpleMutableAttributed<CreationContext>(this);

    private CreationContext() {
    }

    public static <T> T use(Callable<T> actions) {
        CreationContext.begin();
        try {
            T t = actions.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            CreationContext.end();
        }
    }

    public static Optional<CreationContext> current() {
        Stack<CreationContext> cs = CONTEXT.get();
        return cs.empty() ? Optional.empty() : Optional.of(cs.peek());
    }

    public static CreationContext begin() {
        CreationContext ctx = new CreationContext();
        CONTEXT.get().push(ctx);
        return ctx;
    }

    public static void end() {
        Stack<CreationContext> cs = CONTEXT.get();
        if (!cs.empty()) {
            cs.pop();
        }
    }

    public MutableAttributed<CreationContext> nodes() {
        return this.nodeAttributes;
    }

    public MutableAttributed<CreationContext> links() {
        return this.linkAttributes;
    }

    public MutableAttributed<CreationContext> graphs() {
        return this.graphAttributes;
    }

    static ImmutableNode createNode(Label name) {
        return CreationContext.current().map(ctx -> ctx.newNode(name)).orElseGet(() -> new ImmutableNode(name));
    }

    private ImmutableNode newNode(Label name) {
        return this.immutableNodes.computeIfAbsent(name, ImmutableNode::new).with((Attributes)this.nodeAttributes);
    }

    static MutableNode createMutNode(Label name) {
        return CreationContext.current().map(ctx -> ctx.newMutNode(name)).orElseGet(() -> new MutableNode().setName(name));
    }

    private MutableNode newMutNode(Label name) {
        return this.mutableNodes.computeIfAbsent(name, l -> new MutableNode().setName((Label)l)).add((Attributes)this.nodeAttributes);
    }

    static Link createLink(LinkSource from, LinkTarget to) {
        Link link = new Link(from, to, Attributes.attrs(new Attributes[0]));
        return CreationContext.current().map(ctx -> link.with((Attributes)ctx.linkAttributes)).orElse(link);
    }
}

