/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributed;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.MapAttributes;
import guru.nidi.graphviz.attribute.MutableAttributed;
import guru.nidi.graphviz.attribute.SimpleMutableAttributed;
import guru.nidi.graphviz.model.CreationContext;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.Node;

public final class Link
implements Attributed<Link>,
LinkTarget {
    final LinkSource from;
    final LinkTarget to;
    final MutableAttributed<Link> attributes;

    public static Link to(MutableNode node) {
        return Link.to(node.withRecord(null));
    }

    public static Link to(Node node) {
        return Link.to(node.port());
    }

    public static Link to(LinkTarget to) {
        return Link.objBetween(null, to);
    }

    public LinkTarget to() {
        return this.to;
    }

    public static Link between(Node from, Node to) {
        return Link.between(from.port(), to.port());
    }

    public static Link between(LinkSource from, LinkTarget to) {
        return Link.objBetween(from, to);
    }

    private static Link objBetween(LinkSource from, LinkTarget to) {
        return CreationContext.createLink(from, to);
    }

    Link(LinkSource from, LinkTarget to, Attributes attributes) {
        this.from = from;
        this.to = to;
        this.attributes = new SimpleMutableAttributed<Link>(this, attributes);
    }

    @Override
    public Link with(Attributes attrs) {
        return new Link(this.from, this.to, attrs.applyTo(this.attributes.applyTo(Attributes.attrs(new Attributes[0]))));
    }

    @Override
    public Attributes applyTo(MapAttributes attrs) {
        return this.attributes.applyTo(attrs);
    }

    @Override
    public Link linkTo() {
        return this;
    }

    public LinkSource from() {
        return this.from;
    }

    public MutableAttributed<Link> attrs() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return this.attributes.equals(link.attributes);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.attributes.hashCode();
        return result;
    }
}

