/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.SvgRasterizer;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;

class BatikRasterizer
extends SvgRasterizer {
    BatikRasterizer() {
    }

    @Override
    public BufferedImage doRasterize(Graphviz graphviz, @Nullable Consumer<Graphics2D> graphicsConfigurer, String svg) {
        final BufferedImage[] image = new BufferedImage[1];
        TranscoderInput in = new TranscoderInput((Reader)new StringReader(svg));
        try {
            TranscoderOutput out = new TranscoderOutput(new OutputStream(){

                @Override
                public void write(int b) {
                }
            });
            PNGTranscoder t = new PNGTranscoder(){

                public BufferedImage createImage(int width, int height) {
                    image[0] = super.createImage(width, height);
                    return image[0];
                }
            };
            TranscodingHints hints = new TranscodingHints((Map)t.getTranscodingHints());
            if (graphviz.width != 0) {
                hints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)Float.valueOf((float)graphviz.scale * (float)graphviz.width));
            }
            if (graphviz.height != 0) {
                hints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)Float.valueOf((float)graphviz.scale * (float)graphviz.height));
            }
            t.setTranscodingHints(hints);
            t.transcode(in, out);
            return image[0];
        }
        catch (TranscoderException e) {
            throw new GraphvizException("Error during rasterization", e);
        }
    }
}

