/*
 * Decompiled with CFR 0.152.
 */
package javaposse.jobdsl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javaposse.jobdsl.dsl.DslScriptLoader;
import javaposse.jobdsl.dsl.FileJobManagement;
import javaposse.jobdsl.dsl.GeneratedItems;
import javaposse.jobdsl.dsl.GeneratedJob;
import javaposse.jobdsl.dsl.GeneratedView;
import javaposse.jobdsl.dsl.JobManagement;
import javaposse.jobdsl.dsl.ScriptRequest;

public class Run {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new RuntimeException("Script name is required");
        }
        File cwd = new File(".");
        URL cwdURL = cwd.toURI().toURL();
        FileJobManagement jm = new FileJobManagement(cwd);
        jm.getParameters().putAll(System.getenv());
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            jm.getParameters().put(entry.getKey().toString(), entry.getValue().toString());
        }
        ArrayList<String> scripts = new ArrayList<String>();
        for (String arg : args) {
            if (!arg.startsWith("--")) continue;
            scripts.add(arg);
        }
        for (String scriptName : args) {
            ScriptRequest request = new ScriptRequest(scriptName, null, cwdURL, false);
            GeneratedItems generatedItems = DslScriptLoader.runDslEngine(request, (JobManagement)jm);
            for (GeneratedJob job : generatedItems.getJobs()) {
                System.out.println("From " + scriptName + ", Generated job: " + job);
            }
            for (GeneratedView view : generatedItems.getViews()) {
                System.out.println("From " + scriptName + ", Generated view: " + view);
            }
        }
    }
}

