/*
 * Decompiled with CFR 0.152.
 */
package javaposse.jobdsl.dsl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import groovy.util.GroovyScriptEngine;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javaposse.jobdsl.dsl.GeneratedItems;
import javaposse.jobdsl.dsl.GeneratedJob;
import javaposse.jobdsl.dsl.GeneratedView;
import javaposse.jobdsl.dsl.Job;
import javaposse.jobdsl.dsl.JobManagement;
import javaposse.jobdsl.dsl.JobParent;
import javaposse.jobdsl.dsl.ScriptRequest;
import javaposse.jobdsl.dsl.View;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.runtime.InvokerHelper;

public class DslScriptLoader {
    private static final Logger LOGGER = Logger.getLogger(DslScriptLoader.class.getName());

    public static JobParent runDslEngineForParent(ScriptRequest scriptRequest, JobManagement jobManagement) throws IOException {
        JobParent jp;
        ClassLoader parentClassLoader = DslScriptLoader.class.getClassLoader();
        CompilerConfiguration config = DslScriptLoader.createCompilerConfiguration(jobManagement);
        GroovyClassLoader cl = new GroovyClassLoader(parentClassLoader, config);
        ImportCustomizer icz = new ImportCustomizer();
        icz.addStaticStars(new String[]{"javaposse.jobdsl.dsl.JobType"});
        icz.addStaticStars(new String[]{"javaposse.jobdsl.dsl.ViewType"});
        icz.addStaticStars(new String[]{"javaposse.jobdsl.dsl.helpers.common.MavenContext.LocalRepositoryLocation"});
        config.addCompilationCustomizers(new CompilationCustomizer[]{icz});
        GroovyScriptEngine engine = new GroovyScriptEngine(new URL[]{scriptRequest.urlRoot}, (ClassLoader)cl);
        engine.setConfig(config);
        Binding binding = DslScriptLoader.createBinding(jobManagement);
        try {
            Script script;
            if (scriptRequest.body != null) {
                Class cls = engine.getGroovyClassLoader().parseClass(scriptRequest.body);
                script = InvokerHelper.createScript((Class)cls, (Binding)binding);
            } else {
                script = engine.createScript(scriptRequest.location, binding);
            }
            assert (script instanceof JobParent);
            jp = (JobParent)script;
            jp.setJm(jobManagement);
            binding.setVariable("jobFactory", (Object)jp);
            script.run();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IOException("Unable to run script", e);
        }
        return jp;
    }

    static GeneratedItems runDslEngine(String scriptBody, JobManagement jobManagement) throws IOException {
        ScriptRequest scriptRequest = new ScriptRequest(null, scriptBody, new File(".").toURL());
        return DslScriptLoader.runDslEngine(scriptRequest, jobManagement);
    }

    public static GeneratedItems runDslEngine(ScriptRequest scriptRequest, JobManagement jobManagement) throws IOException {
        JobParent jp = DslScriptLoader.runDslEngineForParent(scriptRequest, jobManagement);
        LOGGER.log(Level.FINE, String.format("Ran script and got back %s", new Object[]{jp}));
        GeneratedItems generatedItems = new GeneratedItems();
        generatedItems.setJobs(DslScriptLoader.extractGeneratedJobs(jp, scriptRequest.ignoreExisting));
        generatedItems.setViews(DslScriptLoader.extractGeneratedViews(jp, scriptRequest.ignoreExisting));
        DslScriptLoader.scheduleJobsToRun(jp.getQueueToBuild(), jobManagement);
        return generatedItems;
    }

    private static Set<GeneratedJob> extractGeneratedJobs(JobParent jp, boolean ignoreExisting) {
        LinkedHashSet generatedJobs = Sets.newLinkedHashSet();
        if (jp != null) {
            ArrayList refJobs = Lists.newArrayList(jp.getReferencedJobs());
            Collections.sort(refJobs, new Comparator<Job>(){

                @Override
                public int compare(Job o1, Job o2) {
                    return o1.getType().ordinal() - o2.getType().ordinal();
                }
            });
            for (Job job : refJobs) {
                try {
                    String xml = job.getXml();
                    LOGGER.log(Level.FINE, String.format("Saving job %s as %s", job.getName(), xml));
                    boolean created = jp.getJm().createOrUpdateConfig(job.getName(), xml, ignoreExisting);
                    GeneratedJob gj = new GeneratedJob(job.getTemplateName(), job.getName(), created);
                    generatedJobs.add(gj);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
        }
        return generatedJobs;
    }

    private static Set<GeneratedView> extractGeneratedViews(JobParent jp, boolean ignoreExisting) {
        LinkedHashSet generatedViews = Sets.newLinkedHashSet();
        for (View view : jp.getReferencedViews()) {
            String xml = view.getXml();
            LOGGER.log(Level.FINE, String.format("Saving view %s as %s", view.getName(), xml));
            jp.getJm().createOrUpdateView(view.getName(), xml, ignoreExisting);
            GeneratedView gv = new GeneratedView(view.getName());
            generatedViews.add(gv);
        }
        return generatedViews;
    }

    static void scheduleJobsToRun(List<String> jobNames, JobManagement jobManagement) {
        HashMap exceptions = Maps.newHashMap();
        for (String string : jobNames) {
            try {
                jobManagement.queueJob(string);
            }
            catch (Exception e) {
                exceptions.put(string, e);
            }
        }
        if (!exceptions.isEmpty()) {
            LOGGER.warning("Trouble schedule some jobs");
            for (Map.Entry entry : exceptions.entrySet()) {
                LOGGER.throwing("DslScriptLoader", (String)entry.getKey(), (Throwable)entry.getValue());
            }
        }
    }

    private static Binding createBinding(JobManagement jobManagement) {
        Binding binding = new Binding();
        binding.setVariable("out", (Object)jobManagement.getOutputStream());
        Map<String, String> params = jobManagement.getParameters();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            LOGGER.fine(String.format("Binding %s to %s", entry.getKey(), entry.getValue()));
            binding.setVariable(entry.getKey(), (Object)entry.getValue());
        }
        return binding;
    }

    private static CompilerConfiguration createCompilerConfiguration(JobManagement jobManagement) {
        CompilerConfiguration config = new CompilerConfiguration(CompilerConfiguration.DEFAULT);
        config.setScriptBaseClass("javaposse.jobdsl.dsl.JobParent");
        ImportCustomizer icz = new ImportCustomizer();
        icz.addImports(new String[]{"javaposse.jobdsl.dsl.helpers.Permissions"});
        icz.addImports(new String[]{"javaposse.jobdsl.dsl.helpers.publisher.PublisherContext.Behavior"});
        icz.addImports(new String[]{"javaposse.jobdsl.dsl.views.ListView.StatusFilter"});
        icz.addImports(new String[]{"javaposse.jobdsl.dsl.views.BuildPipelineView.OutputStyle"});
        config.addCompilationCustomizers(new CompilationCustomizer[]{icz});
        config.setOutput(new PrintWriter(jobManagement.getOutputStream()));
        return config;
    }
}

